
var gulp         = require('gulp');
var browserSync  = require('browser-sync');
var gutil        = require('gulp-util');
var notify       = require('gulp-notify');
var sass         = require('gulp-sass');
var less         = require('gulp-less');
var ftp          = require('vinyl-ftp');


// Send to FTP
gulp.task( 'ftp', function () {
	gulp.src( ["html/*.*"], { base: 'html', buffer: false } ).pipe( conn.dest( '' ) );	
	gulp.src( ["html/images/*.*"], { base: 'html/images', buffer: false } ).pipe( conn.dest( 'images' ) );
	gulp.src( ["html/mail/*.*"], { base: 'html/mail', buffer: false } ).pipe( conn.dest( 'mail' ) );
	gulp.src( ["html/images/review/*.*"], { base: 'html/images/review', buffer: false } ).pipe( conn.dest( 'images/review' ) );
	gulp.src( ["html/js/*.js"], { base: 'html/js', buffer: false } ).pipe( conn.dest( 'js' ) );
	gulp.src( ["html/css/*.*"], { base: 'html/css', buffer: false } ).pipe( conn.dest( 'css' ) );
	gulp.src( ["html/sass/*.*"], { base: 'html/sass', buffer: false } ).pipe( conn.dest( 'sass' ) );	
	gulp.src( ["html/fonts/*.*"], { base: 'html/fonts', buffer: false } ).pipe( conn.dest( 'fonts' ) );
});	
	

gulp.task('browserSync', function () {
  browserSync({
    server: {
      baseDir: "./html",
	  index: "index.html"
    },
	port: 8787,
    open: true,
    notify: false,
  });
});


gulp.task('sass', function() {
	return gulp.src('html/sass/*.scss')
	.pipe(sass({ outputStyle: 'expand' }).on('error', notify.onError()))
	.pipe(gulp.dest('html/css'))
	.pipe(browserSync.reload({ stream: true }));
});

/**/
gulp.task('watch', function () {
  gulp.watch(['html/sass/*.scss','html/sass/*/*.scss'], ['sass']);
});


gulp.task('build', ['sass']);


gulp.task('default', ['browserSync','watch','sass'], function() {
  gulp.watch('html/index.html', browserSync.reload);
});
