$(function () {

    $(document).ready(function () {

        // Build the chart
        $('#container').highcharts({
            chart: {
                plotBackgroundColor: null,
                plotBorderWidth: null,
                plotShadow: false,
                type: 'pie'
            },
credits: {
      enabled: false
  },			
            title: {
                text: "",
				style:{	fontSize: '30px'}			
            },
            tooltip: {
                pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>'
            },
            plotOptions: {
                pie: {
                    allowPointSelect: true,
                    cursor: 'pointer',
                    dataLabels: {
                        enabled: true,
						distance: -20,
						style:{
								color: 'white',
								fontSize: '20px',
								textShadow: false 
								},
						formatter: function () {return this.y + '%';}
                    },
                    showInLegend: true
                }
            },
            series: [{
				fontSize: '20px',
                name: 'Эффект лечения',
                colorByPoint: true,
                data: [{
                    name: 'Клиническое выздоровление',
                    y: 88,
                    sliced: true,
                    selected: true,
					color: "#76c248"
                }, {
                    name: 'Значительное улучшение',
                    y: 7,
					color: "#046ab5"
                }, {
                    name: 'Без эффекта',
                    y: 5,
					color: "#D00"
                }
                ]
            }]
        });
    });
});