# Compass SASS Stylesheets (SASS files)



![Compass sass](http://zpalexander.com/wp-content/uploads/2015/04/sass-compass.jpg)

Run in shell
```sh
bower install compass-sass-mixins
```

Open your file.sass and import the library
```sass

@import "bower_components/compass-sass-mixins/lib/compass"

/*
use your sass mixins here
*/

```

# Compass Mixins

### A

*   [adjust-font-size-to($to-size, $lines, $from-size)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-adjust-font-size-to)
*   [adjust-leading-to($lines, $font-size)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-adjust-leading-to)
*   [align-content($align-content)](http://compass-style.org/reference/compass/css3/flexbox/#mixin-align-content)
*   [align-items($align-items)](http://compass-style.org/reference/compass/css3/flexbox/#mixin-align-items)
*   [align-self($align-self)](http://compass-style.org/reference/compass/css3/flexbox/#mixin-align-self)
*   [alternating-rows-and-columns($even-row-color, $odd-row-color, $dark-intersection, $header-color, $footer-color)](http://compass-style.org/reference/compass/utilities/tables/alternating_rows_and_columns/#mixin-alternating-rows-and-columns)
*   [animation](http://compass-style.org/reference/compass/css3/animation/#mixin-animation)
*   [animation-delay](http://compass-style.org/reference/compass/css3/animation/#mixin-animation-delay)
*   [animation-direction](http://compass-style.org/reference/compass/css3/animation/#mixin-animation-direction)
*   [animation-duration](http://compass-style.org/reference/compass/css3/animation/#mixin-animation-duration)
*   [animation-fill-mode](http://compass-style.org/reference/compass/css3/animation/#mixin-animation-fill-mode)
*   [animation-iteration-count](http://compass-style.org/reference/compass/css3/animation/#mixin-animation-iteration-count)
*   [animation-name](http://compass-style.org/reference/compass/css3/animation/#mixin-animation-name)
*   [animation-play-state](http://compass-style.org/reference/compass/css3/animation/#mixin-animation-play-state)
*   [animation-timing-function](http://compass-style.org/reference/compass/css3/animation/#mixin-animation-timing-function)
*   [appearance($appearance)](http://compass-style.org/reference/compass/css3/appearance/#mixin-appearance)
*   [apply-origin($origin, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-apply-origin)
*   [apply-side-rhythm-border($side, $width, $lines, $font-size, $border-style)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-apply-side-rhythm-border)

### B

*   [backface-visibility($visibility)](http://compass-style.org/reference/compass/css3/transform/#mixin-backface-visibility)
*   [background](http://compass-style.org/reference/compass/css3/images/#mixin-background)
*   [background-clip](http://compass-style.org/reference/compass/css3/background_clip/#mixin-background-clip)
*   [background-image](http://compass-style.org/reference/compass/css3/images/#mixin-background-image)
*   [background-origin](http://compass-style.org/reference/compass/css3/background_origin/#mixin-background-origin)
*   [background-size](http://compass-style.org/reference/compass/css3/background_size/#mixin-background-size)
*   [background-with-css2-fallback](http://compass-style.org/reference/compass/css3/images/#mixin-background-with-css2-fallback)
*   [bang-hack($property, $value, $ie6-value)](http://compass-style.org/reference/compass/utilities/general/hacks/#mixin-bang-hack)
*   [baseline-grid-background($baseline, $color)](http://compass-style.org/reference/compass/layout/grid_background/#mixin-baseline-grid-background)
*   [border-bottom-left-radius($radius)](http://compass-style.org/reference/compass/css3/border_radius/#mixin-border-bottom-left-radius)
*   [border-bottom-radius($radius)](http://compass-style.org/reference/compass/css3/border_radius/#mixin-border-bottom-radius)
*   [border-bottom-right-radius($radius)](http://compass-style.org/reference/compass/css3/border_radius/#mixin-border-bottom-right-radius)
*   [border-corner-radius($vert, $horz, $radius)](http://compass-style.org/reference/compass/css3/border_radius/#mixin-border-corner-radius)
*   [border-image($value)](http://compass-style.org/reference/compass/css3/images/#mixin-border-image)
*   [border-left-radius($radius)](http://compass-style.org/reference/compass/css3/border_radius/#mixin-border-left-radius)
*   [border-radius($radius, $vertical-radius)](http://compass-style.org/reference/compass/css3/border_radius/#mixin-border-radius)
*   [border-right-radius($radius)](http://compass-style.org/reference/compass/css3/border_radius/#mixin-border-right-radius)
*   [border-top-left-radius($radius)](http://compass-style.org/reference/compass/css3/border_radius/#mixin-border-top-left-radius)
*   [border-top-radius($radius)](http://compass-style.org/reference/compass/css3/border_radius/#mixin-border-top-radius)
*   [border-top-right-radius($radius)](http://compass-style.org/reference/compass/css3/border_radius/#mixin-border-top-right-radius)
*   [box-align($alignment)](http://compass-style.org/reference/compass/css3/box/#mixin-box-align)
*   [box-direction($direction)](http://compass-style.org/reference/compass/css3/box/#mixin-box-direction)
*   [box-flex($flex)](http://compass-style.org/reference/compass/css3/box/#mixin-box-flex)
*   [box-flex-group($group)](http://compass-style.org/reference/compass/css3/box/#mixin-box-flex-group)
*   [box-lines($lines)](http://compass-style.org/reference/compass/css3/box/#mixin-box-lines)
*   [box-ordinal-group($group)](http://compass-style.org/reference/compass/css3/box/#mixin-box-ordinal-group)
*   [box-orient($orientation)](http://compass-style.org/reference/compass/css3/box/#mixin-box-orient)
*   [box-pack($pack)](http://compass-style.org/reference/compass/css3/box/#mixin-box-pack)
*   [box-shadow](http://compass-style.org/reference/compass/css3/box_shadow/#mixin-box-shadow)
*   [box-sizing($box-model)](http://compass-style.org/reference/compass/css3/box_sizing/#mixin-box-sizing)
*   [break-after($value)](http://compass-style.org/reference/compass/css3/columns/#mixin-break-after)
*   [break-before($value)](http://compass-style.org/reference/compass/css3/columns/#mixin-break-before)
*   [break-inside($value)](http://compass-style.org/reference/compass/css3/columns/#mixin-break-inside)

### C

*   [clearfix](http://compass-style.org/reference/compass/utilities/general/clearfix/#mixin-clearfix)
*   [color-interpolation-filters($value)](http://compass-style.org/reference/compass/css3/filter/#mixin-color-interpolation-filters)
*   [column-break($type, $value)](http://compass-style.org/reference/compass/css3/columns/#mixin-column-break)
*   [column-break-after($value)](http://compass-style.org/reference/compass/css3/columns/#mixin-column-break-after)
*   [column-break-before($value)](http://compass-style.org/reference/compass/css3/columns/#mixin-column-break-before)
*   [column-break-inside($value)](http://compass-style.org/reference/compass/css3/columns/#mixin-column-break-inside)
*   [column-count($count)](http://compass-style.org/reference/compass/css3/columns/#mixin-column-count)
*   [column-fill($fill)](http://compass-style.org/reference/compass/css3/columns/#mixin-column-fill)
*   [column-gap($width)](http://compass-style.org/reference/compass/css3/columns/#mixin-column-gap)
*   [column-grid-background($total, $column, $gutter, $offset, $column-color, $gutter-color, $force-fluid)](http://compass-style.org/reference/compass/layout/grid_background/#mixin-column-grid-background)
*   [column-rule($width, $style, $color)](http://compass-style.org/reference/compass/css3/columns/#mixin-column-rule)
*   [column-rule-color($color)](http://compass-style.org/reference/compass/css3/columns/#mixin-column-rule-color)
*   [column-rule-style($style)](http://compass-style.org/reference/compass/css3/columns/#mixin-column-rule-style)
*   [column-rule-width($width)](http://compass-style.org/reference/compass/css3/columns/#mixin-column-rule-width)
*   [column-span($columns)](http://compass-style.org/reference/compass/css3/columns/#mixin-column-span)
*   [column-span($span)](http://compass-style.org/reference/compass/css3/columns/#mixin-column-span)
*   [column-width($width)](http://compass-style.org/reference/compass/css3/columns/#mixin-column-width)
*   [columns($width-and-count)](http://compass-style.org/reference/compass/css3/columns/#mixin-columns)
*   [comma-delimited-list](http://compass-style.org/reference/compass/typography/lists/inline_list/#mixin-comma-delimited-list)
*   [content($value)](http://compass-style.org/reference/compass/css3/images/#mixin-content)
*   [contrasted($background-color, $dark, $light, $threshold)](http://compass-style.org/reference/compass/utilities/color/contrast/#mixin-contrasted)
*   [create-transform($perspective, $scale-x, $scale-y, $scale-z, $rotate-x, $rotate-y, $rotate-z, $rotate3d, $trans-x, $trans-y, $trans-z, $skew-x, $skew-y, $origin-x, $origin-y, $origin-z, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-create-transform)

### D

*   [debug-vertical-alignment($img)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-debug-vertical-alignment)
*   [delimited-list($separator)](http://compass-style.org/reference/compass/typography/lists/inline_list/#mixin-delimited-list)
*   [display-box](http://compass-style.org/reference/compass/css3/box/#mixin-display-box)
*   [display-flex($display)](http://compass-style.org/reference/compass/css3/flexbox/#mixin-display-flex)

### E

*   [each-gradient-prefix($values)](http://compass-style.org/reference/compass/css3/images/#mixin-each-gradient-prefix)
*   [ellipsis($no-wrap)](http://compass-style.org/reference/compass/typography/text/ellipsis/#mixin-ellipsis)
*   [establish-baseline($font-size)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-establish-baseline)

### F

*   [filter($filters)](http://compass-style.org/reference/compass/css3/filter/#mixin-filter)
*   [filter-gradient($start-color, $end-color, $orientation)](http://compass-style.org/reference/compass/css3/images/#mixin-filter-gradient)
*   [filter-margin($widths)](http://compass-style.org/reference/compass/css3/filter/#mixin-filter-margin)
*   [filter-margin-bottom($width)](http://compass-style.org/reference/compass/css3/filter/#mixin-filter-margin-bottom)
*   [filter-margin-left($width)](http://compass-style.org/reference/compass/css3/filter/#mixin-filter-margin-left)
*   [filter-margin-right($width)](http://compass-style.org/reference/compass/css3/filter/#mixin-filter-margin-right)
*   [filter-margin-top($width)](http://compass-style.org/reference/compass/css3/filter/#mixin-filter-margin-top)
*   [flex($flex)](http://compass-style.org/reference/compass/css3/flexbox/#mixin-flex)
*   [flex-basis($flex-basis)](http://compass-style.org/reference/compass/css3/flexbox/#mixin-flex-basis)
*   [flex-direction($direction)](http://compass-style.org/reference/compass/css3/flexbox/#mixin-flex-direction)
*   [flex-flow($flow)](http://compass-style.org/reference/compass/css3/flexbox/#mixin-flex-flow)
*   [flex-grow($flex-grow)](http://compass-style.org/reference/compass/css3/flexbox/#mixin-flex-grow)
*   [flex-shrink($flex-shrink)](http://compass-style.org/reference/compass/css3/flexbox/#mixin-flex-shrink)
*   [flex-wrap($wrap)](http://compass-style.org/reference/compass/css3/flexbox/#mixin-flex-wrap)
*   [flexbox($properties, $version)](http://compass-style.org/reference/compass/css3/flexbox/#mixin-flexbox)
*   [float($side)](http://compass-style.org/reference/compass/utilities/general/float/#mixin-float)
*   [float-left](http://compass-style.org/reference/compass/utilities/general/float/#mixin-float-left)
*   [float-right](http://compass-style.org/reference/compass/utilities/general/float/#mixin-float-right)
*   [flow-from($target)](http://compass-style.org/reference/compass/css3/regions/#mixin-flow-from)
*   [flow-into($target)](http://compass-style.org/reference/compass/css3/regions/#mixin-flow-into)
*   [font-face($name, $font-files, $eot, $weight, $style)](http://compass-style.org/reference/compass/css3/font_face/#mixin-font-face)
*   [for-legacy-browser($browser, $min-version, $max-version, $threshold, $ranges)](http://compass-style.org/reference/compass/support/#mixin-for-legacy-browser)
*   [for-legacy-browsers($browsers, $threshold)](http://compass-style.org/reference/compass/support/#mixin-for-legacy-browsers)
*   [force-wrap](http://compass-style.org/reference/compass/typography/text/force-wrap/#mixin-force-wrap)

### G

*   [global-reset](http://compass-style.org/reference/compass/reset/utilities/#mixin-global-reset)
*   [global-reset](http://compass-style.org/reference/compass/reset-legacy/utilities-legacy/#mixin-global-reset)
*   [grid-background($total, $column, $gutter, $baseline, $offset, $column-color, $gutter-color, $baseline-color, $force-fluid)](http://compass-style.org/reference/compass/layout/grid_background/#mixin-grid-background)

### H

*   [h-borders($width, $lines, $font-size, $border-style)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-h-borders)
*   [has-layout($approach)](http://compass-style.org/reference/compass/utilities/general/hacks/#mixin-has-layout)
*   [has-layout-block](http://compass-style.org/reference/compass/utilities/general/hacks/#mixin-has-layout-block)
*   [has-layout-zoom](http://compass-style.org/reference/compass/utilities/general/hacks/#mixin-has-layout-zoom)
*   [hide-text($direction)](http://compass-style.org/reference/compass/typography/text/replacement/#mixin-hide-text)
*   [horizontal-borders($width, $lines, $font-size, $border-style)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-horizontal-borders)
*   [horizontal-list($padding, $direction)](http://compass-style.org/reference/compass/typography/lists/horizontal_list/#mixin-horizontal-list)
*   [horizontal-list-container](http://compass-style.org/reference/compass/typography/lists/horizontal_list/#mixin-horizontal-list-container)
*   [horizontal-list-item($padding, $direction)](http://compass-style.org/reference/compass/typography/lists/horizontal_list/#mixin-horizontal-list-item)
*   [hover-link](http://compass-style.org/reference/compass/typography/links/hover_link/#mixin-hover-link)
*   [hyphenation](http://compass-style.org/reference/compass/css3/hyphenation/#mixin-hyphenation)
*   [hyphens($value)](http://compass-style.org/reference/compass/css3/hyphenation/#mixin-hyphens)

### I

*   [image-property($property)](http://compass-style.org/reference/compass/css3/images/#mixin-image-property)
*   [inline-block($alignment, $ie-alignment)](http://compass-style.org/reference/compass/css3/inline_block/#mixin-inline-block)
*   [inline-block-list($padding)](http://compass-style.org/reference/compass/typography/lists/inline-block-list/#mixin-inline-block-list)
*   [inline-block-list-container](http://compass-style.org/reference/compass/typography/lists/inline-block-list/#mixin-inline-block-list-container)
*   [inline-block-list-item($padding)](http://compass-style.org/reference/compass/typography/lists/inline-block-list/#mixin-inline-block-list-item)
*   [inline-list](http://compass-style.org/reference/compass/typography/lists/inline_list/#mixin-inline-list)
*   [inner-table-borders($width, $color)](http://compass-style.org/reference/compass/utilities/tables/borders/#mixin-inner-table-borders)
*   [input-placeholder](http://compass-style.org/reference/compass/css3/user_interface/#mixin-input-placeholder)

### J

*   [justify-content($justify-content)](http://compass-style.org/reference/compass/css3/flexbox/#mixin-justify-content)

### K

*   [keyframes($name)](http://compass-style.org/reference/compass/css3/animation/#mixin-keyframes)

### L

*   [leader($lines, $font-size, $property)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-leader)
*   [leading-border($width, $lines, $font-size, $border-style)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-leading-border)
*   [legacy-pie-clearfix](http://compass-style.org/reference/compass/utilities/general/clearfix/#mixin-legacy-pie-clearfix)
*   [link-colors($normal, $hover, $active, $visited, $focus)](http://compass-style.org/reference/compass/typography/links/link_colors/#mixin-link-colors)
*   [list-style($value)](http://compass-style.org/reference/compass/css3/images/#mixin-list-style)
*   [list-style-image($image)](http://compass-style.org/reference/compass/css3/images/#mixin-list-style-image)

### M

*   [margin-leader($lines, $font-size)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-margin-leader)
*   [margin-trailer($lines, $font-size)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-margin-trailer)
*   [min-height($value)](http://compass-style.org/reference/compass/utilities/general/min/#mixin-min-height)
*   [min-width($value)](http://compass-style.org/reference/compass/utilities/general/min/#mixin-min-width)

### N

*   [nested-reset](http://compass-style.org/reference/compass/reset/utilities/#mixin-nested-reset)
*   [nested-reset](http://compass-style.org/reference/compass/reset-legacy/utilities-legacy/#mixin-nested-reset)
*   [no-bullet](http://compass-style.org/reference/compass/typography/lists/bullets/#mixin-no-bullet)
*   [no-bullets](http://compass-style.org/reference/compass/typography/lists/bullets/#mixin-no-bullets)
*   [nowrap](http://compass-style.org/reference/compass/typography/text/nowrap/#mixin-nowrap)

### O

*   [opacity($opacity)](http://compass-style.org/reference/compass/css3/opacity/#mixin-opacity)
*   [opaque](http://compass-style.org/reference/compass/css3/opacity/#mixin-opaque)
*   [order($order)](http://compass-style.org/reference/compass/css3/flexbox/#mixin-order)
*   [outer-table-borders($width, $color)](http://compass-style.org/reference/compass/utilities/tables/borders/#mixin-outer-table-borders)

### P

*   [padding-leader($lines, $font-size)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-padding-leader)
*   [padding-trailer($lines, $font-size)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-padding-trailer)
*   [perspective($p)](http://compass-style.org/reference/compass/css3/transform/#mixin-perspective)
*   [perspective-origin($origin)](http://compass-style.org/reference/compass/css3/transform/#mixin-perspective-origin)
*   [pie-clearfix](http://compass-style.org/reference/compass/utilities/general/clearfix/#mixin-pie-clearfix)
*   [prefix-prop($property, $value, $prefix)](http://compass-style.org/reference/compass/support/#mixin-prefix-prop)
*   [prefixed-properties($capability, $threshold, $properties, $capability-options)](http://compass-style.org/reference/compass/support/#mixin-prefixed-properties)
*   [pretty-bullets($bullet-icon, $width, $height, $line-height, $padding)](http://compass-style.org/reference/compass/typography/lists/bullets/#mixin-pretty-bullets)
*   [print-utilities($media)](http://compass-style.org/reference/compass/utilities/print/#mixin-print-utilities)

### R

*   [replace-text($img, $x, $y)](http://compass-style.org/reference/compass/typography/text/replacement/#mixin-replace-text)
*   [replace-text-with-dimensions($img, $x, $y, $inline)](http://compass-style.org/reference/compass/typography/text/replacement/#mixin-replace-text-with-dimensions)
*   [reset-baseline($font-size)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-reset-baseline)
*   [reset-body](http://compass-style.org/reference/compass/reset/utilities/#mixin-reset-body)
*   [reset-body](http://compass-style.org/reference/compass/reset-legacy/utilities-legacy/#mixin-reset-body)
*   [reset-box-model](http://compass-style.org/reference/compass/reset-legacy/utilities-legacy/#mixin-reset-box-model)
*   [reset-box-model](http://compass-style.org/reference/compass/reset/utilities/#mixin-reset-box-model)
*   [reset-display($selector, $important)](http://compass-style.org/reference/compass/reset/utilities/#mixin-reset-display)
*   [reset-display($selector, $important)](http://compass-style.org/reference/compass/reset-legacy/utilities-legacy/#mixin-reset-display)
*   [reset-float($display)](http://compass-style.org/reference/compass/utilities/general/float/#mixin-reset-float)
*   [reset-focus](http://compass-style.org/reference/compass/reset/utilities/#mixin-reset-focus)
*   [reset-focus](http://compass-style.org/reference/compass/reset-legacy/utilities-legacy/#mixin-reset-focus)
*   [reset-font](http://compass-style.org/reference/compass/reset/utilities/#mixin-reset-font)
*   [reset-font](http://compass-style.org/reference/compass/reset-legacy/utilities-legacy/#mixin-reset-font)
*   [reset-html5](http://compass-style.org/reference/compass/reset/utilities/#mixin-reset-html5)
*   [reset-html5](http://compass-style.org/reference/compass/reset-legacy/utilities-legacy/#mixin-reset-html5)
*   [reset-image-anchor-border](http://compass-style.org/reference/compass/reset-legacy/utilities-legacy/#mixin-reset-image-anchor-border)
*   [reset-image-anchor-border](http://compass-style.org/reference/compass/reset/utilities/#mixin-reset-image-anchor-border)
*   [reset-list-style](http://compass-style.org/reference/compass/reset-legacy/utilities-legacy/#mixin-reset-list-style)
*   [reset-list-style](http://compass-style.org/reference/compass/reset/utilities/#mixin-reset-list-style)
*   [reset-quotation](http://compass-style.org/reference/compass/reset-legacy/utilities-legacy/#mixin-reset-quotation)
*   [reset-quotation](http://compass-style.org/reference/compass/reset/utilities/#mixin-reset-quotation)
*   [reset-table](http://compass-style.org/reference/compass/reset/utilities/#mixin-reset-table)
*   [reset-table](http://compass-style.org/reference/compass/reset-legacy/utilities-legacy/#mixin-reset-table)
*   [reset-table-cell](http://compass-style.org/reference/compass/reset-legacy/utilities-legacy/#mixin-reset-table-cell)
*   [reset-table-cell](http://compass-style.org/reference/compass/reset/utilities/#mixin-reset-table-cell)
*   [rhythm($leader, $padding-leader, $padding-trailer, $trailer, $font-size)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-rhythm)
*   [rhythm-borders($width, $lines, $font-size, $border-style)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-rhythm-borders)
*   [rhythm-margins($leader, $trailer, $font-size)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-rhythm-margins)
*   [rhythm-padding($padding-leader, $padding-trailer, $font-size)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-rhythm-padding)
*   [rotate($rotate, $perspective, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-rotate)
*   [rotate3d($vector-x, $vector-y, $vector-z, $rotate, $perspective)](http://compass-style.org/reference/compass/css3/transform/#mixin-rotate3d)
*   [rotateX($rotate, $perspective)](http://compass-style.org/reference/compass/css3/transform/#mixin-rotateX)
*   [rotateY($rotate, $perspective)](http://compass-style.org/reference/compass/css3/transform/#mixin-rotateY)
*   [rotateZ($rotate, $perspective, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-rotateZ)

### S

*   [scale($scale-x, $scale-y, $perspective, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-scale)
*   [scale3d($scale-x, $scale-y, $scale-z, $perspective)](http://compass-style.org/reference/compass/css3/transform/#mixin-scale3d)
*   [scaleX($scale, $perspective, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-scaleX)
*   [scaleY($scale, $perspective, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-scaleY)
*   [scaleZ($scale, $perspective)](http://compass-style.org/reference/compass/css3/transform/#mixin-scaleZ)
*   [selection($background-color, $color)](http://compass-style.org/reference/compass/css3/selection/#mixin-selection)
*   [simple-transform($scale, $rotate, $trans-x, $trans-y, $skew-x, $skew-y, $origin-x, $origin-y)](http://compass-style.org/reference/compass/css3/transform/#mixin-simple-transform)
*   [single-box-shadow($hoff, $voff, $blur, $spread, $color, $inset)](http://compass-style.org/reference/compass/css3/box_shadow/#mixin-single-box-shadow)
*   [single-text-shadow($hoff, $voff, $blur, $spread, $color)](http://compass-style.org/reference/compass/css3/text-shadow/#mixin-single-text-shadow)
*   [single-transition($property, $duration, $function, $delay)](http://compass-style.org/reference/compass/css3/transition/#mixin-single-transition)
*   [skew($skew-x, $skew-y, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-skew)
*   [skewX($skew-x, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-skewX)
*   [skewY($skew-y, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-skewY)
*   [sprite($map, $sprite, $dimensions, $offset-x, $offset-y, $use-percentages, $use-magic-selectors, $separator)](http://compass-style.org/reference/compass/utilities/sprites/base/#mixin-sprite)
*   [sprite-background($img, $width, $height)](http://compass-style.org/reference/compass/utilities/sprites/sprite_img/#mixin-sprite-background)
*   [sprite-background-position($map, $sprite, $offset-x, $offset-y, $use-percentages)](http://compass-style.org/reference/compass/utilities/sprites/base/#mixin-sprite-background-position)
*   [sprite-background-rectangle($img, $width, $height)](http://compass-style.org/reference/compass/utilities/sprites/sprite_img/#mixin-sprite-background-rectangle)
*   [sprite-column($col, $width, $margin)](http://compass-style.org/reference/compass/utilities/sprites/sprite_img/#mixin-sprite-column)
*   [sprite-dimensions($map, $sprite)](http://compass-style.org/reference/compass/utilities/sprites/base/#mixin-sprite-dimensions)
*   [sprite-img($img, $col, $row, $width, $height, $margin)](http://compass-style.org/reference/compass/utilities/sprites/sprite_img/#mixin-sprite-img)
*   [sprite-position($col, $row, $width, $height, $margin)](http://compass-style.org/reference/compass/utilities/sprites/sprite_img/#mixin-sprite-position)
*   [sprite-replace-text($map, $sprite, $dimensions, $offset-x, $offset-y)](http://compass-style.org/reference/compass/utilities/sprites/sprite_img/#mixin-sprite-replace-text)
*   [sprite-replace-text-with-dimensions($map, $sprite, $offset-x, $offset-y)](http://compass-style.org/reference/compass/utilities/sprites/sprite_img/#mixin-sprite-replace-text-with-dimensions)
*   [sprite-row($row, $height, $margin)](http://compass-style.org/reference/compass/utilities/sprites/sprite_img/#mixin-sprite-row)
*   [sprites($map, $sprite-names, $base-class, $dimensions, $prefix, $offset-x, $offset-y, $use-percentages, $separator)](http://compass-style.org/reference/compass/utilities/sprites/base/#mixin-sprites)
*   [squish-text](http://compass-style.org/reference/compass/typography/text/replacement/#mixin-squish-text)
*   [sticky-footer($footer-height, $root-selector, $root-footer-selector, $footer-selector)](http://compass-style.org/reference/compass/layout/sticky_footer/#mixin-sticky-footer)
*   [stretch($offset-top, $offset-right, $offset-bottom, $offset-left)](http://compass-style.org/reference/compass/layout/stretching/#mixin-stretch)
*   [stretch-x($offset-left, $offset-right)](http://compass-style.org/reference/compass/layout/stretching/#mixin-stretch-x)
*   [stretch-y($offset-top, $offset-bottom)](http://compass-style.org/reference/compass/layout/stretching/#mixin-stretch-y)

### T

*   [table-scaffolding](http://compass-style.org/reference/compass/utilities/tables/scaffolding/#mixin-table-scaffolding)
*   [tag-cloud($base-size)](http://compass-style.org/reference/compass/utilities/general/tag_cloud/#mixin-tag-cloud)
*   [text-shadow](http://compass-style.org/reference/compass/css3/text-shadow/#mixin-text-shadow)
*   [trailer($lines, $font-size, $property)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-trailer)
*   [trailing-border($width, $lines, $font-size, $border-style)](http://compass-style.org/reference/compass/typography/vertical_rhythm/#mixin-trailing-border)
*   [transform($transform, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-transform)
*   [transform-origin($origin-x, $origin-y, $origin-z, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-transform-origin)
*   [transform-style($style)](http://compass-style.org/reference/compass/css3/transform/#mixin-transform-style)
*   [transform2d($trans)](http://compass-style.org/reference/compass/css3/transform/#mixin-transform2d)
*   [transform3d($trans)](http://compass-style.org/reference/compass/css3/transform/#mixin-transform3d)
*   [transition](http://compass-style.org/reference/compass/css3/transition/#mixin-transition)
*   [transition-delay](http://compass-style.org/reference/compass/css3/transition/#mixin-transition-delay)
*   [transition-duration](http://compass-style.org/reference/compass/css3/transition/#mixin-transition-duration)
*   [transition-property](http://compass-style.org/reference/compass/css3/transition/#mixin-transition-property)
*   [transition-timing-function](http://compass-style.org/reference/compass/css3/transition/#mixin-transition-timing-function)
*   [translate($translate-x, $translate-y, $perspective, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-translate)
*   [translate3d($translate-x, $translate-y, $translate-z, $perspective)](http://compass-style.org/reference/compass/css3/transform/#mixin-translate3d)
*   [translateX($trans-x, $perspective, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-translateX)
*   [translateY($trans-y, $perspective, $only3d)](http://compass-style.org/reference/compass/css3/transform/#mixin-translateY)
*   [translateZ($trans-z, $perspective)](http://compass-style.org/reference/compass/css3/transform/#mixin-translateZ)
*   [transparent](http://compass-style.org/reference/compass/css3/opacity/#mixin-transparent)

### U

*   [underscore-hack($property, $value, $ie6-value)](http://compass-style.org/reference/compass/utilities/general/hacks/#mixin-underscore-hack)
*   [unstyled-link](http://compass-style.org/reference/compass/typography/links/unstyled_link/#mixin-unstyled-link)
*   [user-select($select)](http://compass-style.org/reference/compass/css3/user_interface/#mixin-user-select)

### W

*   [with-browser-ranges($capability, $prefix)](http://compass-style.org/reference/compass/support/#mixin-with-browser-ranges)
*   [with-browser-support-debugging](http://compass-style.org/reference/compass/support/#mixin-with-browser-support-debugging)
*   [with-each-prefix($capability, $threshold, $capability-options)](http://compass-style.org/reference/compass/support/#mixin-with-each-prefix)
*   [with-prefix($prefix)](http://compass-style.org/reference/compass/support/#mixin-with-prefix)
*   [word-break($value)](http://compass-style.org/reference/compass/css3/hyphenation/#mixin-word-break)
