<?php
/**
 * Jetpack Compatibility File.
 *
 * @link https://jetpack.me/
 *
 * @package Karuna
 */

/**
 * Jetpack setup function.
 *
 * See: https://jetpack.me/support/infinite-scroll/
 * See: https://jetpack.me/support/responsive-videos/
 */
function karuna_jetpack_setup() {
	// Add theme support for Infinite Scroll.
	add_theme_support( 'infinite-scroll', array(
		'container'      => 'main',
		'render'         => 'karuna_infinite_scroll_render',
		'footer'         => 'page',
		'footer_widgets' => array( 'sidebar-2', 'sidebar-3', 'sidebar-5', 'sidebar-6', 'sidebar-7' ),
	) );

	// Add theme support for Responsive Videos.
	add_theme_support( 'jetpack-responsive-videos' );

	// Add theme support for Social Menus
	add_theme_support( 'jetpack-social-menu' );

	// Add theme support for testimonials
	add_theme_support( 'jetpack-testimonial' );

	//Add theme support for Content Settings.
	add_theme_support( 'jetpack-content-settings', array(
		'blog-display' => 'content',
		'author-bio'   => true,
		'post-details' => array(
			'stylesheet' => 'karuna-style',
			'date'       => 'posted-on',
			'categories' => 'cat-links',
			'tags'       => 'tags-links',
		)
	) );
}
add_action( 'after_setup_theme', 'karuna_jetpack_setup' );

/**
 * Custom render function for Infinite Scroll.
 */
function karuna_infinite_scroll_render() {
	while ( have_posts() ) {
		the_post();
		if ( is_search() ) :
		    get_template_part( 'components/post/content', 'search' );
		else :
		    get_template_part( 'components/post/content', get_post_format() );
		endif;
	}
}

/*
 * Only display social menu if function exists
 */
function karuna_social_menu() {
	if ( ! function_exists( 'jetpack_social_menu' ) ) {
		return;
	} else {
		jetpack_social_menu();
	}
}

/*
 * Adjust content width for Tiled Galleries when using the Header or Full-Width widget areas
 */
function karuna_jetpack_gallery_widget_width( $width ) {
	if ( ! is_active_sidebar( 'sidebar-5' ) && ! is_active_sidebar( 'sidebar-4' ) ) {
		return;
	}

	$width = 1040;

	return $width;
}
add_filter( 'gallery_widget_content_width', 'karuna_jetpack_gallery_widget_width' );

/**
 * Return early if Author Bio is not available.
 */
function karuna_author_bio() {
	if ( ! function_exists( 'jetpack_author_bio' ) ) {
		return;
	} else {
		jetpack_author_bio();
	}
}

/**
 * Author Bio Avatar Size.
 */
function karuna_author_bio_avatar_size() {
	return 60;
}
add_filter( 'jetpack_author_bio_avatar_size', 'karuna_author_bio_avatar_size' );
