<?php
class SeoReader
{   
	private $pdo=null;
	private $tableNames=array('template_groups'=>'template_groups', 'templates'=>'templates');

	public function __construct($pdo, $tableNames){
		$this->pdo=$pdo;		
		$this->tableNames=$tableNames;
	}


	public function readProduct($productId){
		$products=$this->tableNames['products'];
		
		$stmt = $this->pdo->prepare("SELECT seotitle, seoh1, seodescr, seokeywords, seolink  FROM $products WHERE  id=?");	

		$stmt->execute([$productId]);
		$seovars = $stmt->fetch();
		
		$seo=new Seo($seovars);
		return ($seo);
	}   
	
	public function readProducts(){
		$products=$this->tableNames['products'];
		
		$stmt = $this->pdo->prepare("SELECT id, seotitle, seoh1, seodescr, seokeywords, seolink  FROM $products");	

		$stmt->execute();
		$seoArray = $stmt->fetchAll();
		
		$seo=new SeoArray($seoArray);
		return ($seo);
	} 	
}

class SeoArray
{
   private $seoArray = array();
	
   public function __construct($seoArray)
   {
		foreach ($seoArray as $seovars){
			$this->seoArray[] = new Seo($seovars);
		}
   }
   
   
    public function getIdByLink($link) 
	{
		foreach ($this->seoArray as $seovars){
			$tmp=$seovars->getVars();
			if($tmp['seolink']==$link){return $tmp['id'];}
		}		
	}
	
    public function getLinks() 
	{
		$result = array();
		foreach ($this->seoArray as $seovars){
			$tmp=$seovars->getVars();
			if($tmp['seolink']==""){$tmp['seolink']=null;}
			$result[$tmp['id']] = $tmp['seolink'];
		}
		return $result;
	}     
	
    public function getArray() 
	{
		return $this->seoArray;
	}  	
	
}

class Seo
{
   private $seovars = array();
	
   public function __construct($seovars)
   {
		$this->seovars = $seovars;
   }

	
    public function getVars() 
	{
		return $this->seovars;
	}  	
	
}
?>