<?php
include "headers.inc.php";
include "functions.inc.php";
include "../assets/config/config.php";
$output = [];
$index = 0;


//TABLES SET NAMES
$images = $tableNames['images'];
$image_groups = $tableNames['image_groups'];


//VARS GET NAMES
$gallery = $_GET['gallery'];
$ratio = isset($_GET['ratio']) ? $_GET['ratio'] : false;
$groupId = isset($_GET['groupId']) & $_GET['groupId'] != '' & $_GET['groupId'] != 'undefined' ? $_GET['groupId'] : false; //TODO: make function

try {
  $pdo = new PDO('mysql:host=' . $pdohost . ';dbname=' . $pdobase . ';charset=utf8', $pdouser, $pdopass);
} catch (PDOException $e) {
  $output['syserror'] = $e->getMessage();
  $output['message'] = "PDO connection error";
}



if (isset($pdo)) {
  if (isset($_GET["groups"])) {
    $stmt = $pdo->prepare("SELECT $image_groups.*, COUNT($images.origid) AS as_members FROM $image_groups LEFT JOIN $images ON $images.img_group_id=$image_groups.id WHERE type=? GROUP BY $image_groups.id");
    $q = $stmt->execute([$gallery]);
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($result as $row) {
      if ($row['as_members'] == 0) {
        continue;
      }
      foreach ($row as $key => $value) {
        if(is_numeric($value)){$output[$index][underToCamel($key)] = (int)$value;}
        else{$output[$index][underToCamel($key)] = $value;}
      }
      $index++;
    }
   
  } else {

    if ($groupId) {
      $stmt = $pdo->prepare("SELECT $images.*, $images.img_group_id as group_id FROM $images  WHERE type=? AND img_group_id=? ORDER BY $images.id");
      $q = $stmt->execute([$gallery, $groupId]);
    } else {
      $stmt = $pdo->prepare("SELECT $images.*, $images.img_group_id as group_id FROM $images  WHERE type=? ORDER BY $images.id");
      $q = $stmt->execute([$gallery]);
    }



    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($result as $row) {
      if ($ratio && $gallery == "backgrounds") {
        if (($row['width'] / $row['height'] + $backgroundPrecision) < $ratio) {
          continue;
        }
        if (($row['width'] / $row['height'] - $backgroundPrecision) > $ratio) {
          continue;
        };
      }

      foreach ($row as $key => $value) {
        if(is_numeric($value)){$output[$index][underToCamel($key)] = (int)$value;}
        else{$output[$index][underToCamel($key)] = $value;}
      }
      $index++;
    }
  }
}


echo json_encode($output, $jsonEncMode);
