<?php
class Template
{
	private $filedir     = 111111111111111;
	private $productId   =	0;
	private $width       =	 	100;
	private $height      =		100;
	private $css         =  "";
	private $js          =  "";
	private $rawbg       =  "";
	private $cut         =	2;
	private $canvasArray =  array();
	private $folds       =  array();
	//private $isround   = false;
	private $opacity     = 1;

	//private $pathFix =  "";


	public function __construct($width, $height, $productId, $filedir)
	{
		$this->width = $width;
		$this->height = $height;
		$this->productId = $productId;
		$this->filedir = $filedir;
	}

	public function setRetext($dictionary)
	{
		foreach ($this->canvasArray as $canvas) {
			$canvas->setRetext($dictionary);
		}
	}

	public function setJs($js)
	{
		$this->js = $js;
	}

	public function getJs()
	{
		return $this->js;
	}

	public function setCss($css)
	{
		$this->css = $css;
	}

	public function getCss()
	{
		return $this->css;
	}

	public function getFiledir()
	{
		return $this->filedir;
	}

	public function setRawbg($rawbg)
	{
		$this->rawbg = $rawbg;
	}

	public function getRawbg()
	{
		return $this->rawbg;
	}


	public function setSize($width, $height)
	{
		$this->width = $width;
		$this->height = $height;
	}

	public function setFolds($folds)
	{
		$this->folds = $folds;
	}


	public function getFolds()
	{
		return $this->folds;
	}

	/*
   public function getIsround()
   {
	   return $this->isround;
   }  
   
   public function setIsround($isround)
   {
	   $this->isround = $isround;
   }  
   */

	public function getCut()
	{
		return $this->cut;
	}

	public function setCut($cut)
	{
		$this->cut = $cut;
	}


	public function setProductId($productId)
	{
		$this->productId = $productId;
	}

	public function getProductId()
	{
		return $this->productId;
	}


	public function addCanvas($canvas)
	{
		$this->canvasArray[] = $canvas;
	}


	public function getCanvas($index)
	{
		return $this->canvasArray[$index];
	}

	public function getAllCanvas()
	{
		return $this->canvasArray;
	}

	public function getSize()
	{
		return array($this->width, $this->height);
	}

	public function __toString()
	{
		return (serialize($this));
	}
}





class Canvas implements JsonSerializable
{
	private $background = "";
	private $backgroundImage = "";
	private $objects =  array();
	private $width =	 	100;
	private $height =		100;

	public function setRetext($dictionary)
	{
		foreach ($this->objects as $object) {
			$object->setRetext($dictionary);
		}
	}


	public function __construct()
	{
	}

	public function getSize()
	{
		return array($this->width, $this->height);
	}

	public function setSize($width, $height)
	{
		$this->width = $width;
		$this->height = $height;
	}

	public function setBackground($background)
	{
		$this->background = $background;
	}

	public function setBackgroundImage($backgroundImage)
	{
		$this->backgroundImage = $backgroundImage;
	}

	public function addObject($object)
	{
		$this->objects[] = $object;
	}

	public function getObjects()
	{
		return $this->objects;
	}


	public function __toString()
	{
		return (serialize($this));
	}

	public function jsonSerialize()
	{
		return array('objects' => $this->objects, 'background' => $this->background, 'backgroundImage' => $this->backgroundImage);
	}

	public function toJson53()
	{
		foreach ($this->objects as $object) {
			$json_array[] = $object->jsonSerialize();
		}

		$json["objects"] = $json_array;
		$json["background"] = $this->background;
		if (method_exists($this->backgroundImage, 'jsonSerialize')) {
			$json["backgroundImage"] = $this->backgroundImage->jsonSerialize();
		}

		$str = json_encode($json);
		$str = str_replace("\/", "/", $str);
		return ($str);
	}

	public function toJson()
	{
		$str = json_encode($this);
		$str = str_replace("\/", "/", $str);
		return ($str);
	}
}




class ColorStop implements JsonSerializable
{
	private $offset =	 			0;
	private $color = 				"#000000";
	private $opacity = 				1;

	public function __construct($offset = 0, $color = "#000000", $opacity = 1)
	{
		$this->offset = $offset;
		$this->color = $color;
		$this->opacity = $opacity;
	}

	public function jsonSerialize()
	{
		$obj['offset'] = $this->offset;
		$obj['color'] = $this->color;
		$obj['opacity'] = $this->opacity;
		return $obj;
	}
}

class Coords implements JsonSerializable
{
	public $x1 =	 			0;
	public $x2 = 				0;
	public $y1 = 				0;
	public $y2 = 				0;
	public $r1 = 				0;
	public $r2 = 				0;

	public function __construct($x1 = 0, $x2 = 0, $y1 = 0, $y2 = 0, $r1 = 0, $r2 = 0)
	{
		$this->x1 = $x1;
		$this->x2 = $x2;
		$this->y1 = $y1;
		$this->y2 = $y2;
		$this->r1 = $r1;
		$this->r2 = $r2;
	}

	public function jsonSerialize()
	{
		$scaleFactor = TemplateConfig::getScaleFactor();

		$obj['x1'] = $this->x1 * $scaleFactor;
		$obj['x2'] = $this->x2 * $scaleFactor;
		$obj['y1'] = $this->y1 * $scaleFactor;
		$obj['y2'] = $this->y2 * $scaleFactor;
		$obj['r1'] = $this->r1 * $scaleFactor;
		$obj['r2'] = $this->r2 * $scaleFactor;
		return $obj;
	}
}

class Gradient implements JsonSerializable
{
	private $colorStops = array();
	private $type = null;
	public $coords = null;
	private $matrix = array(1, 0, 0, 1, 0, 0);
	private $offsetX = 0;
	private $offsetY = 0;

	public function __construct($type = null, $coords = null)
	{
		$this->type = $type;
		$this->coords = $coords;
	}

	public function setMatrix($matrix)
	{
		$this->matrix = $matrix;
	}

	public function setOffsets($offsetX, $offsetY)
	{
		$this->offsetX = $offsetX;
		$this->offsetY = $offsetY;
	}


	public  function addColorStop($colorStops)
	{
		$this->colorStops[] = $colorStops;
	}

	public function __toString()
	{
		return (serialize($this));
	}

	public function jsonSerialize()
	{
		$scaleFactor = TemplateConfig::getScaleFactor();

		$obj['type'] = $this->type;
		$obj['coords'] = $this->coords;
		$obj['colorStops'] = $this->colorStops;
		$obj['offsetX'] = $this->offsetX * $scaleFactor;
		$obj['offsetY'] = $this->offsetY * $scaleFactor;
		$matrix = $this->matrix;
		$matrix[4] = $matrix[4] * $scaleFactor;
		$matrix[5] = $matrix[5] * $scaleFactor;
		$obj['gradientTransform'] = $matrix;

		return $obj;
	}

	// {"type":"linear","coords":{"x1":115,"y1":23.18181818181818,"x2":285,"y2":23.18181818181818},"colorStops":[{"offset":1,"color":"rgb(255,0,0)","opacity":1},{"offset":0,"color":"rgb(255,255,0)","opacity":1}],"offsetX":-115,"offsetY":-15,"gradientTransform":[1,0,0,0.6470588235294118,0,0]}
}

class TemplateConfig
{
	private static $scaleFactor = 1;
	private static $pathFix = "";
	private static $imgOptimized = false;


	public static function setImgOptimized()
	{
		self::$imgOptimized = true;
	}

	public static function unsetImgOptimized()
	{
		self::$imgOptimized = false;
	}

	public static function getImgOptimized()
	{
		return  self::$imgOptimized;
	}

	public static function setScaleFactor($scaleFactor)
	{
		self::$scaleFactor = $scaleFactor;
	}

	public static function getScaleFactor()
	{
		return  self::$scaleFactor;
	}

	public static function setPathFix($pathFix)
	{
		self::$pathFix = $pathFix;
	}

	public static function getPathFix()
	{
		return  self::$pathFix;
	}
}





class ObjectImg extends ObjectBase implements JsonSerializable
{
	private $src =				 	"";
	public $type =	 			"image";
	private $optScreen =           1024;

	public function __construct($src = null)
	{
		$this->src = $src;
		$this->visible = true;
		//sprint ($src);	  
	}


	public function jsonSerialize()
	{

		$scaleFactor = TemplateConfig::getScaleFactor();
		$pathFix = TemplateConfig::getPathFix();

		if (TemplateConfig::getImgOptimized()) {
			$src = str_replace("/images/", '/screens/', $this->src);
		} else {
			$src = $this->src;
		}
		$obj = parent::jsonSerialize();


		$fixedWidth  = is_string($this->width) ? $this->width : round($this->width * $scaleFactor, 2);
		$fixedHeight = is_string($this->height) ? $this->height : round($this->height * $scaleFactor, 2);

		if (TemplateConfig::getImgOptimized() & $this->width > $this->optScreen) {
			$newWidth = $this->optScreen;
			$newHeight = $newWidth * $fixedHeight / $fixedWidth;
			$newScaleX = $fixedWidth * $this->scaleX / $newWidth;
			$newScaleY = $fixedHeight * $this->scaleY / $newHeight;
		} else {
			$newWidth =  $fixedWidth;
			$newHeight = $fixedHeight;
			$newScaleX =  $this->scaleX;
			$newScaleY =  $this->scaleY;
		}


		$obj['width'] = $newWidth;
		$obj['height'] = $newHeight;

		$obj['scaleX'] = $newScaleX;
		$obj['scaleY'] = $newScaleY;

		$obj['src'] = $pathFix . $src;
		$obj['filters'] = $this->filters;
		$obj['resizeFilters'] = $this->resizeFilters;
		$obj['crossOrigin'] = "";
		$obj['alignX'] = "none";
		$obj['alignY'] = "none";
		$obj['meetOrSlice'] = "meet";

		return $obj;
	}
}

class ObjectPathGroup extends ObjectBase implements JsonSerializable
{
	private $paths =  array();
	public $type =	  "path-group";


	public function __construct()
	{
		$this->visible = true;
	}

	public function addObject($obj)
	{
		$this->paths[] = $obj;
	}

	public function jsonSerialize()
	{
		$paths = $this->paths;

		if ($this->left == INF) {
			$this->left = 0;
		}
		if ($this->top == INF) {
			$this->top = 0;
		}

		if (is_string($paths) == false) {
			for ($c = 0; $c < count($this->paths); $c++) {
				//$paths[$c]->setGroupFlag(true);

				if (is_float($paths[$c]->left)) {
					$paths[$c]->left = $paths[$c]->left - $this->left;
				}
				if (is_float($paths[$c]->top)) {
					$paths[$c]->top = $paths[$c]->top - $this->top;
				}


				// print "is";
				if ($paths[$c]->getMyType() == "polyline" | $paths[$c]->getMyType() == "polygon") {
					$points = $paths[$c]->getPoints();
					for ($c2 = 0; $c2 < count($points); $c2++) {
						$points[$c2]->x = $points[$c2]->x - $this->left;
						$points[$c2]->y = $points[$c2]->y - $this->top;
					}
					$paths[$c]->setPoints($points);
				}


				if ($paths[$c]->getMyType() == "path") {
					$path = $paths[$c]->getPath();
					for ($c2 = 0; $c2 < count($path); $c2++) {
						if ($path[$c2][0] == "M" | $path[$c2][0] == "L" | $path[$c2][0] == "S") {
							//print_r($path[$c2]);
							for ($c3 = 1; $c3 < count($path[$c2]); $c3 = $c3 + 2) {
								$path[$c2][$c3] = $path[$c2][$c3] - $this->left;
								$path[$c2][$c3 + 1] = $path[$c2][$c3 + 1] - $this->top;
							}/**/
						} elseif ($path[$c2][0] == "V") {
							$path[$c2][1] = $path[$c2][1] - $this->top;
						} elseif ($path[$c2][0] == "H") {
							$path[$c2][1] = $path[$c2][1] - $this->left;
						} else {
							$path[$c2] = $path[$c2];
						}

						//$path[$c2]->x=$path[$c2]->x-$this->left;
						//$path[$c2]->y=$path[$c2]->y-$this->top;
					}	/*			*/
					$paths[$c]->setPath($path);
				}

				if ($paths[$c]->getMyType() == "line") {
					//$points=$paths[$c]->getPoints();		
					//print_r($paths[$c]);
					list($x1, $x2, $y1, $y2) = $paths[$c]->getLine();
					//list($x,$y)=$paths[$c]->getPosition();
					$paths[$c]->setLine(($x1 - $this->left), ($x2 - $this->left), ($y1 - $this->top), ($y2 - $this->top));
					//$paths[$c]->setSize(1, 1);
					//print_r(array(min($x1-$this->left, $x2-$this->left),$x,min($y1-$this->top, $y2-$this->top),  $y));
				}
			}
		}



		$scaleFactor = TemplateConfig::getScaleFactor();

		$obj = parent::jsonSerialize();
		$obj['pathOffset'] = new Point(100, 100);
		$obj['paths'] = $paths;
		$obj['groupEnd'] = "";

		return $obj;
	}
}

class ObjectFrameGroup extends ObjectBase implements JsonSerializable
{
	private $objects =  array();
	public $type =	 			"frameGroup";


	public function __construct()
	{
		$this->visible = true;
	}

	public function addObject($obj)
	{
		$this->objects[] = $obj;
	}

	public function jsonSerialize()
	{
		$objects = $this->objects;
		$pathFix = TemplateConfig::getPathFix();

		$obj = parent::jsonSerialize();


		for ($c = 0; $c < count($objects); $c++) {
			if (property_exists($objects[$c], 'src') && strpos($objects[$c]->src, "http://") !== 0 && strpos($objects[$c]->src, "https://") !== 0) {
				$objects[$c]->src = $pathFix . $objects[$c]->src;
			} elseif (is_object($objects[$c]->fill)) {
				$objects[$c]->fill->source = $pathFix . $objects[$c]->fill->source;
			}
		}

		$obj['objects'] = $objects;
		return $obj;
	}
}



class ObjectGroup extends ObjectBase implements JsonSerializable
{
	private $objects =  array();
	public $type =	 			"group";


	public function __construct()
	{
		$this->visible = true;
	}

	public function addObject($obj)
	{
		$this->objects[] = $obj;
	}

	public function updatePosition()
	{
		for ($c2 = 0; $c2 < count($this->objects); $c2++) {
			if ($this->objects[$c2]->getMyType() == "path") {
				$this->objects[$c2]->fixPath(-$this->width / 2, -$this->height / 2);
				//var_dump($this->objects[$c2]);
			} else {
				$this->objects[$c2]->fixPosition(-$this->width / 2, -$this->height / 2);
			}
		}
	}

	public function jsonSerialize()
	{
		$objects = $this->objects;
		$pathFix = TemplateConfig::getPathFix();

		/*
		$obj = parent::jsonSerialize();
		$obj['objects'] = $objects;	
		
		var_dump($obj);
		*/
		$obj = parent::jsonSerialize();


		for ($c = 0; $c < count($objects); $c++) {
			//if(property_exists( $objects[$c], 'src') && strpos($objects[$c]->src, "http://") !== 0)
			if (property_exists($objects[$c], 'src') && strpos($objects[$c]->src, "http://") !== 0 && strpos($objects[$c]->src, "https://") !== 0) {
				$objects[$c]->src = $pathFix . $objects[$c]->src;
			} elseif (is_object($objects[$c]->fill)) {
				$objects[$c]->fill->source = $pathFix . $objects[$c]->fill->source;
			}
		}

		$obj['objects'] = $objects;

		return $obj;
	}
}


class ObjectSvg extends ObjectBase implements JsonSerializable
{
	public $type =	 			"";
	private $path = null;
	private $points = null;
	//private $d = "";

	public function __construct($type = null)
	{
		$this->type = $type;
		$this->visible = true;
	}

	/*
 	public function setD($d)
	{
      $this->d =  $d;      
	}   
	*/

	public function setPath($path)
	{
		$this->path =  $path;
	}

	public function fixPath($fixleft, $fixtop)
	{
		for ($c = 0; $c < count($this->path); $c++) {
			if ($this->path[$c][0] == "M" | $this->path[$c][0] == "L" | $this->path[$c][0] == "C" | $this->path[$c][0] == "S") {
				$this->path[$c][1] = $this->path[$c][1] + $fixleft;
				$this->path[$c][2] = $this->path[$c][2] + $fixtop;
			}
		}
	}

	public function getPath()
	{
		return $this->path;
	}


	public function setPoints($points)
	{
		$this->points =  $points;
	}

	public function getPoints()
	{
		return $this->points;
	}

	public function scalePath($path, $scaleFactor)
	{
		if ($path == null) {
			return null;
		}

		for ($c = 0; $c < count($path); $c++) {
			$newPath[$c] = $path[$c];
			for ($c2 = 1; $c2 < count($path[$c]); $c2++) {
				$newPath[$c][$c2] = $path[$c][$c2] * $scaleFactor;
			}
		}
		return $newPath;
	}

	public function toD($path, $scaleFactor)
	{
		if ($path == null) {
			return null;
		}
		$d = "";

		for ($c = 0; $c < count($path); $c++) {
			//$newPath[$c]=$path[$c];
			for ($c2 = 0; $c2 < count($path[$c]); $c2++) {
				if ($c2 != 0) {
					$path[$c][$c2] = $path[$c][$c2] * $scaleFactor;
				}
				$d .= $path[$c][$c2] . " ";
			}
			$d .= ",";
		}

		return $d;
	}

	public function jsonSerialize()
	{
		$scaleFactor = TemplateConfig::getScaleFactor();

		$obj = parent::jsonSerialize();
		$obj['filters'] = $this->filters;
		$obj['resizeFilters'] = $this->resizeFilters;
		$obj['crossOrigin'] = "";
		$obj['alignX'] = "none";
		$obj['alignY'] = "none";
		$obj['meetOrSlice'] = "meet";
		$obj['path'] = $this->scalePath($this->path, $scaleFactor);
		if ($this->type == "path") {
			$obj['d'] = $this->toD($this->path, $scaleFactor);
		}
		$obj['points'] = $this->points;
		//$obj['pathOffset']='{"x":75.005,"y":75.005}';
		return $obj;
	}
}



class ObjectCircle extends ObjectBase implements JsonSerializable
{
	public $type =	 			"circle";
	private $radius =	 			0;
	private $startAngle = 			0;
	private $endAngle   = 6.283185307179586;

	public function __construct($radius = 0, $startAngle = 0, $endAngle = 6.283185307179586)
	{
		$this->radius = $radius;
		$this->startAngle = $startAngle;
		$this->endAngle = $endAngle;
	}


	public function jsonSerialize()
	{
		$scaleFactor = TemplateConfig::getScaleFactor();

		$fixAngle = 1;
		if ($this->version < 5) {
			$this->startAngle = rad2deg($this->startAngle);
			$this->endAngle = rad2deg($this->endAngle);
		}

		$obj = parent::jsonSerialize();
		$obj['filters'] = $this->filters;
		$obj['resizeFilters'] = $this->resizeFilters;
		$obj['crossOrigin'] = "";
		$obj['alignX'] = "none";
		$obj['alignY'] = "none";
		$obj['meetOrSlice'] = "meet";
		$obj['radius'] = $this->radius * $scaleFactor;
		$obj['startAngle'] = $this->startAngle;
		$obj['endAngle'] = $this->endAngle;
		return $obj;
	}
}




class ObjectLine extends ObjectBase implements JsonSerializable
{
	public $type =	 			"line";
	private $x1 =	 			0;
	private $x2 = 				0;
	private $y1 = 				0;
	private $y2 = 				0;

	public function __construct($x1 = 0, $x2 = 0, $y1 = 0, $y2 = 0)
	{
		$this->visible = true;

		$this->x1 = $x1;
		$this->x2 = $x2;
		$this->y1 = $y1;
		$this->y2 = $y2;
	}

	public function setLine($x1, $x2, $y1, $y2)
	{
		$this->x1 = $x1;
		$this->x2 = $x2;
		$this->y1 = $y1;
		$this->y2 = $y2;
	}

	public function getLine()
	{
		return (array((int)$this->x1,  (int)$this->x2,  (int)$this->y1, (int)$this->y2));
	}


	public function jsonSerialize()
	{
		$scaleFactor = TemplateConfig::getScaleFactor();

		$obj = parent::jsonSerialize();
		$obj['filters'] = $this->filters;
		$obj['resizeFilters'] = $this->resizeFilters;
		$obj['crossOrigin'] = "";
		$obj['alignX'] = "none";
		$obj['alignY'] = "none";
		$obj['meetOrSlice'] = "meet";
		$obj['x1'] = $this->x1 * $scaleFactor;
		$obj['x2'] = $this->x2 * $scaleFactor;
		$obj['y1'] = $this->y1 * $scaleFactor;
		$obj['y2'] = $this->y2 * $scaleFactor;
		return $obj;
	}
}


class ObjectEllipse extends ObjectBase implements JsonSerializable
{
	public $type =	 			"ellipse";
	private $rx =	 			10;
	private $ry = 				10;

	public function __construct($rx = 0, $ry = 0)
	{
		$this->visible = true;

		$this->rx = $rx;
		$this->ry = $ry;
	}

	public function setEllipse($rx, $ry)
	{
		$this->rx = $rx;
		$this->ry = $ry;
	}

	public function getEllipse()
	{
		return (array((int)$this->rx,  (int)$this->ry));
	}


	public function jsonSerialize()
	{
		$scaleFactor = TemplateConfig::getScaleFactor();

		$obj = parent::jsonSerialize();
		$obj['filters'] = $this->filters;
		$obj['resizeFilters'] = $this->resizeFilters;
		$obj['crossOrigin'] = "";
		$obj['alignX'] = "none";
		$obj['alignY'] = "none";
		$obj['meetOrSlice'] = "meet";
		$obj['rx'] = $this->rx * $scaleFactor;
		$obj['ry'] = $this->ry * $scaleFactor;
		return $obj;
	}
}




class ObjectText extends ObjectBase implements JsonSerializable
{
	protected $text =				 	"";
	public $type =				"text";

	protected $fontSize =				40;
	protected $fontWeight =			"normal";
	protected $fontFamily =			"Roboto";
	protected $fontStyle =			"";
	protected $lineHeight =			1.16;
	protected $charSpacing = 0;

	protected $textAlign =			"left";
	protected $textDecoration =		"";
	protected $textBackgroundColor =	"";
	protected $styles = 			array();
	protected $path = 				null;


	public function __construct($text = "")
	{
		$this->text = $text;
		//$this->visible = false;
	}

	public function setFont($fontSize, $fontFamily)
	{
		$this->fontSize =  $fontSize;
		$this->fontFamily = $fontFamily;
	}

	public function setFontStyle($fontWeight, $fontStyle)
	{
		$this->fontWeight = $fontWeight;
		$this->fontStyle = $fontStyle;
	}

	public function setTextAlign($textAlign)
	{
		$this->textAlign = $textAlign;
	}

	public function setStyles($styles)
	{
		$this->styles = $styles;
	}

	public function setLineHeight($lineHeight)
	{
		$this->lineHeight = $lineHeight;
	}

	public function jsonSerialize()
	{
		$scaleFactor = TemplateConfig::getScaleFactor();


		$obj = parent::jsonSerialize();

		$text = $this->text;


		$text = str_replace("&", "\u0026", $text);
		$text = str_replace("ZE0EUqQxgQ", '\u0027', $text);
		$text = str_replace("QBfWqvLd3a", '\u0022',   $text);

		$textClean = $text;

		//$textClean = str_ireplace(array("{{EMPTY}}","{{EMPTY-EMPTY}}","{{EMPTY@EMPTY}}","{{empty.empty.empty}}"), array("","","",""), $text);
		//$textClean = str_replace(array("\\n"), array(""), $textClean);


		if (strpos($text, "{{") !== false) {
			$obj['retextName'] = str_replace(array("{{", "}}", "\\n"), array("", "", ""), $textClean);
		} else {
			$obj['retextName'] = null;
		}


		$obj['text'] = $textClean;
		$obj['fontWeight'] = $this->fontWeight;
		$obj['fontSize'] = round($this->fontSize * $scaleFactor);
		$obj['fontFamily'] = $this->fontFamily;
		$obj['fontStyle'] = $this->fontStyle;
		$obj['path'] = $this->path;
		$obj['styles'] = $this->styles;
		$obj['textAlign'] = $this->textAlign;
		$obj['lineHeight'] = $this->lineHeight;
		$obj['charSpacing'] = $this->charSpacing;		
		return $obj;
	}
}


class ObjectTextbox extends ObjectText implements JsonSerializable
{
	public $type = "textbox";

	public function __construct($text = "")
	{
		$this->text = $text;
	}

	public function jsonSerialize()
	{
		$obj = parent::jsonSerialize();
		return $obj;
	}
}


class ObjectCurvedText extends ObjectText implements JsonSerializable
{
	private $spacing = 20;
	private $radius = 20;


	public function __construct($text = "")
	{
		$this->text = $text;
		//$this->visible = false;
	}



	public function jsonSerialize()
	{


		$obj = parent::jsonSerialize();

		//$this->type="curvedText";
		$obj['spacing'] = $this->spacing;
		$obj['radius'] = $this->radius;

		return $obj;
	}
}



class Filter implements JsonSerializable
{
	public $type =		"";
	protected $color =		0;
	protected $opacity =	1;

	public function __construct($type = null, $color = "#FFFFFF", $opacity = 0)
	{
		$this->type = $type;
		$this->color = $color;
		$this->opacity = $opacity;
	}

	public function jsonSerialize()
	{
		return array(
			'type'  => $this->type,
			'color' => $this->color,
			'opacity'  => $this->opacity
		);
	}
}


class Point implements JsonSerializable
{
	public $x =		75;
	public $y =		75;

	public function __construct($x = 0, $y = 0)
	{
		$this->x = $x;
		$this->y = $y;
	}

	public function jsonSerialize()
	{
		$scaleFactor = TemplateConfig::getScaleFactor();

		return array(
			'x'  => $this->x * $scaleFactor,
			'y' => $this->y * $scaleFactor
		);
	}
}


class ObjectBase
{
	public $type =		null;
	public $version =		1;
	//public $groupLeft =		0;	
	//public $groupTop =		0;
	public $left =		0;
	public $top =		0;
	public $width =		1;
	public $height =	1;
	public $scaleX = 	1;
	public $scaleY =	1;
	protected $filters = array();
	protected $resizeFilters = array();
	protected $fill = null;
	protected $fillRule = "nonzero";
	protected $stroke = null;
	protected $strokeWidth = 1;
	protected $strokeDashArray = null;
	protected $strokeLineCap = "butt";
	protected $strokeLineJoin = "miter";
	protected $strokeMiterLimit = "10";

	protected $originX = "left";
	protected $originY = "top";
	protected $angle = 0;
	protected $visible = true;
	protected $matrix = null;
	protected $lockMovementX = false;
	protected $lockMovementY = false;
	protected $selectable = true;
	protected $evented = true;
	protected $opacity = 1;
	protected $hoverCursor="";
	protected $padding;

	protected $dictionary = array();
	protected $id = null;
	//protected $groupFlag = false;

	public function setMatrix($matrix)
	{
		$this->matrix = $matrix;
	}

	public function getId()
	{
		return $this->id;
	}

	public function setId($id)
	{
		$this->id = $id;
	}

	public function setRetext($dictionary)
	{
		$this->dictionary = $dictionary;
	}

	/*
	public function loadJson($obj)
	{
		foreach($this as $key => $value) 
		{
			if(isset($obj->$key)==false){}
			$this->$key=$obj->$key;
		}
	}
	*/
	/*
	public function setGroupFlag($groupFlag)
	{
      $this->groupFlag = $groupFlag; 
	}*/

	/*
	public function setGroupPosition($groupLeft, $groupTop)
	{
      $this->groupLeft = $groupLeft;
      $this->groupTop = $groupTop;	  
	}*/

	public function getMyType()
	{
		return $this->type;
	}

	public function setFill($fill)
	{
		$this->fill = $fill;
	}

	public function setStroke($stroke)
	{
		$this->stroke = $stroke;
	}

	public function setStrokeWidth($strokeWidth)
	{
		$this->strokeWidth = $strokeWidth;
	}

	public function setSize($width, $height)
	{
		$this->width = $width;
		$this->height = $height;
	}

	public function getSize()
	{
		return (array($this->width, $this->height));
	}

	public function setScale($scaleX, $scaleY)
	{
		$this->scaleX = $scaleX;
		$this->scaleY = $scaleY;
	}

	public function addFilter($type, $color, $opacity)
	{
		$this->filters[] = new Filter($type, $color, $opacity);
	}

	public function setAngle($angle)
	{
		$this->angle = $angle;
	}

	public function setFillRule($fillRule)
	{
		$this->fillRule = $fillRule;
	}

	public function setStrokeDashArray($strokeDashArray)
	{
		$this->strokeDashArray = $strokeDashArray;
	}

	public function setPosition($left, $top)
	{
		$this->left = $left;
		$this->top = $top;
	}

	public function fixPosition($left, $top)
	{
		$this->left = $this->left + $left;
		$this->top = $this->top + $top;
	}

	public function getPosition()
	{
		return (array($this->left, $this->top));
	}

	public function setOrigin($originX, $originY)
	{
		$this->originX = $originX;
		$this->originY = $originY;
	}

	public function array_multiply(array $array, $number)
	{
		foreach ($array as &$value) {
			if (is_numeric($value)) {
				$value = $value * $number;
			}
		}
		return $array;
	}




	public function jsonSerialize()
	{
		$scaleFactor = TemplateConfig::getScaleFactor();
		$pathFix = TemplateConfig::getPathFix();

		// if($this->id==""){$this->id=substr(str_shuffle ("abcefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890"),0,10);}

		$obj['id'] = $this->id;
		$obj['type'] = $this->type;
		$obj['lockMovementX']  = $this->lockMovementX;
		$obj['lockMovementY'] = $this->lockMovementY;

		$obj['selectable']  = $this->selectable;
		$obj['evented'] = $this->evented;
		$obj['hoverCursor'] = $this->hoverCursor;

		$obj['originX']  = $this->originX;
		$obj['originY'] = $this->originY;
		

		

		//print $this->type; 
		//if(!isset($this->left)){print $this->type.$this->top;}
		$obj['top']  = is_string($this->top) ? $this->top : round($this->top * $scaleFactor, 2);
		$obj['left'] = is_string($this->left) ? $this->left : round($this->left * $scaleFactor, 2);
		$obj['width']  = is_string($this->width) ? $this->width : round($this->width * $scaleFactor, 2);
		$obj['height'] = is_string($this->height) ? $this->height : round($this->height * $scaleFactor, 2);
		//if($obj['type']=="line"){$obj['left']=-100;}

		/*
		
		if($this->groupFlag==true)
		{
		$obj['top2']  = "replace";		
		$obj['left2'] = "replace";			
		}*/
		//print "{".$this->visible."}";
		if ($this->visible == "") {
			$this->visible = true;
		}



		if (is_object($this->fill)) {
			$this->fill->source = $pathFix . $this->fill->source;
		}
		$obj['fill'] = ($this->fill) == "none" ? null : $this->fill;

		$obj['version'] = $this->version;
		$obj['stroke'] = $this->stroke;
		$obj['strokeWidth'] =  round($this->strokeWidth * $scaleFactor, 2);
		$obj['strokeDashArray'] = is_array($this->strokeDashArray) ? $this->array_multiply($this->strokeDashArray, $scaleFactor) : $this->strokeDashArray;
		$obj['strokeLineCap'] = "butt";
		$obj['strokeLineJoin'] = "miter";
		$obj['strokeMiterLimit'] = 10;
		$obj['scaleX'] = $this->scaleX;
		$obj['scaleY'] = $this->scaleY;
		$obj['angle'] = $this->angle;
		$obj['flipX'] = false;
		$obj['flipY'] = false;
		$obj['opacity'] = $this->opacity;
		$obj['shadow'] = null;
		$obj['visible'] = $this->visible;
		$obj['clipTo'] = null;
		$obj['backgroundColor'] = "";
		$obj['fillRule'] = $this->fillRule;
		$obj['globalCompositeOperation'] = "source-over";
		$obj['transformMatrix'] = $this->matrix;
		$obj['skewX'] = 0;
		$obj['skewY'] = 0;
		$obj['padding'] = $this->padding;

		return $obj;
	}
}
