<?php

class ReadTemplate
{
	private $tid = 0;
	private $pdo = null;
	private $tableNames = array('canvas' => 'canvas', 'templates' => 'templates', 'products' => 'products');

	public function __construct($tid, $pdo)
	{
		$this->tid = $tid;
		$this->pdo = $pdo;
	}

	public function setTableName($key, $value)
	{
		//if(!ctype_alnum ($value)){return;}
		if (!ctype_alnum(str_replace("_", "", $value))) {
			exit();
		}
		$this->tableNames[$key] = $value;
	}

	public function setTableNames($tableNames)
	{
		foreach ($tableNames as $key => $value) {
			if (!ctype_alnum(str_replace("_", "", $value))) {
				exit();
			}
			$this->tableNames[$key] = $value;
		}
	}

	public function getCanvasMysql()
	{

		$canvas = $this->tableNames['canvas'];
		// echo "SELECT * FROM $canvas WHERE template_id=".$this->tid."<br>";
		$stmt = $this->pdo->prepare("SELECT * FROM $canvas WHERE template_id=?");
		$stmt->execute([$this->tid]);
		$result = $stmt->fetchAll(); //print($result); 
		return ($result);
	}

	public function getTemplateMysql($tid)
	{
		$products = $this->tableNames['products'];
		$templates = $this->tableNames['templates'];

		$stmt = $this->pdo->prepare("SELECT width, height, cut, $products.id, filedir FROM $products, $templates WHERE $products.id=$templates.product_id AND $templates.id=?");
		$stmt->execute([$tid]);

		$result = $stmt->fetch();

		return (array($result['width'], $result['height'], $result['cut'],  $result['id'],  $result['filedir']));
	}

	public static function  jsonFix($str)
	{
		$str = str_replace("\\n", "\\\\n", $str);
		$str = str_replace("\\r", "\\\\n", $str);
		$str = str_replace("\\t", "\\\\t", $str);
		$str = str_replace("&quot;", '\"', $str);
		$str = str_replace("endAngle", "ignore", $str); //disable property

		$str = mb_convert_encoding($str, 'UTF-8', 'UTF-8');

		if (substr($str, 0, 3) == pack('CCC', 0xef, 0xbb, 0xbf)) {
			$str = substr($str, 3);
		}
		return $str;
	}

	public function read($url, $index_file)
	{
	}



	function cast($destination, $sourceObject)
	{
		if (is_string($destination)) {
			@$destination = new $destination();  /////  Используется конструктор без параметров, поэтому скрыто сообщение об ошибке.
		}
		$sourceReflection = new ReflectionObject($sourceObject);
		$destinationReflection = new ReflectionObject($destination);
		$sourceProperties = $sourceReflection->getProperties();
		foreach ($sourceProperties as $sourceProperty) {
			$sourceProperty->setAccessible(true);
			$name = $sourceProperty->getName();
			$value = $sourceProperty->getValue($sourceObject);
			if ($destinationReflection->hasProperty($name)) {
				$propDest = $destinationReflection->getProperty($name);
				$propDest->setAccessible(true);
				$propDest->setValue($destination, $value);
			} else {
				$destination->$name = $value;
			}
		}
		return $destination;
	}


	public function convert($canvasJson)
	{
		$canvas = new Canvas();

		// var_dump($canvasJson);

		$data = $canvasJson;

		if (is_array($data->objects) == false) {
			return null;
		}
		if (count($data->objects) == 0 & !isset($data->background) & !isset($data->backgroundImage)) {
			return null;
		}

		foreach ($data->objects as $obj) {
			// var_dump($obj);
			if ($obj->type == "i-text") {
				$newObj = $this->cast('ObjectText', $obj);
				$newObj->setStyles([]);
			} elseif ($obj->type == "text") {
				$newObj = $this->cast('ObjectText', $obj);
			} elseif ($obj->type == "textbox") {
				$newObj = $this->cast('ObjectTextbox', $obj);
			} elseif ($obj->type == "image") {
				$newObj = $this->cast('ObjectImg', $obj);
			} elseif ($obj->type == "path-group") {
				$newObj = $this->cast('ObjectPathGroup', $obj);
			} elseif ($obj->type == "frameGroup") {
				$newObj = $this->cast('ObjectFrameGroup', $obj);
			} elseif ($obj->type == "group") {
				$newObj = $this->cast('ObjectGroup', $obj);
			} elseif ($obj->type == "path") {
				$newObj = $this->cast('ObjectSvg', $obj);
			} elseif ($obj->type == "circle") {
				$newObj = $this->cast('ObjectCircle', $obj);
			} elseif ($obj->type == "polygon") {
				$newObj = $this->cast('ObjectSvg', $obj);
			} elseif ($obj->type == "line") {
				$newObj = $this->cast('ObjectLine', $obj);
			} elseif ($obj->type == "rect") {
				$newObj = $this->cast('ObjectSvg', $obj);
			} elseif ($obj->type == "polyline") {
				$newObj = $this->cast('ObjectSvg', $obj);
			}

			//elseif($obj->type=="curvedText"){$newObj = $this->cast('ObjectCurvedText', $obj);}
			else {/*$newObj=null;var_dump($obj);*/
				$newObj = $this->cast('ObjectSvg', $obj);
			}
			//var_dump($newObj);			
			if ($newObj != null) {
				$canvas->addObject($newObj);
			}
		}

		if (isset($data->background) && $data->background != "" && $data->background != null) {
			if ($data->background->type == "radial" || $data->background->type == "linear") {
				//$canvas->setBackground($this->cast('ObjectSvg', $data->background));
			} else {
				//var_dump($data->background);
				$canvas->setBackground((string)$data->background);
			}
		}

		if (isset($data->backgroundImage) && $data->backgroundImage != "" && $data->backgroundImage != null) {
			$canvas->setBackgroundImage($this->cast('ObjectImg', $data->backgroundImage));
		}

		return ($canvas);
	}


	public function  getCanvasStr()
	{
		$strArray = $this->getCanvasMysql();

		foreach ($strArray as $str) {
			$data = $this->jsonFix($str["data"]);
			$canvasJson = json_decode($data);
			//var_dump($canvasJson);
			$canvasNew = $this->convert($canvasJson);


			if ($canvasNew != null) {
				$strArrayData[] = $canvasNew;
			} else {
				$error =  'Empty Template, JsonError: '. json_last_error_msg();
				$strArrayData[] = $this->convert(json_decode($this->jsonFix('{"version":"3.4.0","objects":[{"type":"text","version":"3.4.0","originX":"left","originY":"top","left":15,"top":15,"width":144.23833,"height":22.6,"fill":"#000000","stroke":null,"strokeWidth":1,"strokeDashArray":null,"strokeLineCap":"butt","strokeDashOffset":0,"strokeLineJoin":"miter","strokeMiterLimit":4,"scaleX":1,"scaleY":1,"angle":0,"flipX":false,"flipY":false,"opacity":1,"shadow":null,"visible":true,"clipTo":null,"backgroundColor":"","fillRule":"nonzero","paintFirst":"fill","globalCompositeOperation":"source-over","transformMatrix":null,"skewX":0,"skewY":0,"text":"'.$error.'","fontSize":20,"fontWeight":"","fontFamily":"Roboto","fontStyle":"normal","lineHeight":1.16,"underline":false,"overline":false,"linethrough":false,"textAlign":"left","textBackgroundColor":"","charSpacing":0,"styles":{}}]}')));
			}
		}

		if (!isset($strArrayData)) {
			$strArrayData[] = $this->convert(json_decode($this->jsonFix('{"version":"3.5.0","objects":[{"type":"text","version":"3.4.0","originX":"left","originY":"top","left":15,"top":15,"width":144.23833,"height":22.6,"fill":"#000000","stroke":null,"strokeWidth":1,"strokeDashArray":null,"strokeLineCap":"butt","strokeDashOffset":0,"strokeLineJoin":"miter","strokeMiterLimit":4,"scaleX":1,"scaleY":1,"angle":0,"flipX":false,"flipY":false,"opacity":1,"shadow":null,"visible":true,"clipTo":null,"backgroundColor":"","fillRule":"nonzero","paintFirst":"fill","globalCompositeOperation":"source-over","transformMatrix":null,"skewX":0,"skewY":0,"text":"Empty Template","fontSize":20,"fontWeight":"","fontFamily":"Roboto","fontStyle":"normal","lineHeight":1.16,"underline":false,"overline":false,"linethrough":false,"textAlign":"left","textBackgroundColor":"","charSpacing":0,"styles":{}}]}')));
		}

		return $strArrayData;
	}

	public function  getTemplate()
	{
		list($width, $height, $cut, $productId, $filedir) = $this->getTemplateMysql($this->tid);

		// var_dump($width, $height, $cut, $productId, $filedir);
		$template = new Template($width, $height, $productId, $filedir);
		$template->setCut($cut);

		if (is_array($this->getCanvasStr()) == false) {
			$template->addCanvas(new Canvas());
			return $template;
		}

		foreach ($this->getCanvasStr() as $canvas) {
			$template->addCanvas($canvas);
		}

		return $template;
	}
}
