<?php
session_start();
include "headers.inc.php";

ignore_user_abort(true);

include("../assets/config/config.php");
include_once("./classes/class.Template.php");
include_once("./classes/class.ExportTemplate.php");

//$oldCanvasDir= "../../canvas/";
$canvasDir= "../";

$_POST = json_decode(file_get_contents("php://input"), true);


//TABLES SET NAMES
$bcanvas = $tableNames['bcanvas'];
$btemplates = $tableNames['btemplates'];


//VARS GET NAMES
$id = $_POST["id"];
$format = $_POST["format"];
$rawBgCoords = isset($_POST["rawBgCoordsJson"]) ? json_decode($_POST["rawBgCoordsJson"], true) : false;
$productId = $_POST["productId"];
$filedir = $_POST["filedir"];
$randomDir = (int) $filedir . "/";
$saveDir = $canvasDir . $ordersDir . $randomDir;
$data = $_POST["canvas"];

try {
	$pdo = new PDO('mysql:host=' . $pdohost . ';dbname=' . $pdobase . ';charset=utf8', $pdouser, $pdopass);
} catch (PDOException $e) {
	$output['syserror'] = $e->getMessage();
	$output['message'] = "i.PdoConnectionError";
}


if($rawBgCoords){
	if (count($rawBgCoords) != 4) {
		$rawBgCoords = false;
	}
}


@mkdir($saveDir);

if ($format == "json-admin") {
	$_POST["method"] = $format;
	$_SESSION['MwsPostJson'] = $_POST;
	header('Location: '. $canvasAdminUrl . 'php/templates_set.php?sessionPost=MwsPostJson');
	exit();
} elseif ($format == "png-admin") {
	$_POST["method"] = $format;
	$_SESSION['MwsPostPng'] = $_POST;
	header('Location: '. $canvasAdminUrl . 'php/templates_set.php?sessionPost=MwsPostPng');
	exit();
} elseif ($format == "json") {
	$writer = new ExportTemplateJSON($canvasDir, $ordersDir, $id, $filedir, $data, $pdo, $productId);
	$writer->setTables(array("canvas" => $bcanvas, "templates" => $btemplates));
	$output = $writer->write();
	$output['message'] = "i.Exported";
	$output['pages'] = count($data);
	$output["status"] = 1;
	$output["filedir"] = $filedir;
} elseif ($format == "png-preview") {
	for ($c = 0; $c < count($data); $c++) {
		$writer = new ExportTemplatePNG($saveDir . "page$c.png", $data[$c], false);
		$writer->write();
	}
	$output['message'] = "i.Exported";
	$output['pages'] = count($data);
	$output["status"] = 1;
	$output["filedir"] = $filedir;
} elseif ($format == "png-print") {
	for ($c = 0; $c < count($data); $c++) {
		$writer = new ExportTemplatePNG($saveDir . "print-page$c.png", $data[$c], $rawBgCoords);
		$writer->write();
	}
	$output['message'] = "i.Exported";
	$output['pages'] = count($data);
	$output["status"] = 1;
	$output["filedir"] = $filedir;
} elseif ($format == "pdf") {
	$dest = $saveDir . "pdfprint";
	@mkdir($dest, 0777, true);
	$global_counter = 0;

	for ($c = 0; $c < count($data); $c++) {
		$writer = new ExportTemplateSVG($dest . "/oripage$c.svg", $data[$c]);
		$writer->write();

		$data[$c] = str_replace('\"', '"', $data[$c]);
		$data[$c] = str_replace("/screens/", "/images/", $data[$c]);
		// $data[$c] = str_replace("//", "/", $data[$c]);

		list(, $svg)	= explode("</defs>", $data[$c]);
		$arrayUrls	= explode('href="', $svg);
		$arrayUrlsClean = array();

		for ($c2 = 1; $c2 < count($arrayUrls); $c2++) {
			list($url) = explode('"', $arrayUrls[$c2]);
			//if (is_array($arrayUrlsClean)){
			if (!in_array($url, $arrayUrlsClean)) {
				$arrayUrlsClean[] = $url;
			}
			//}
		}

		//file_put_contents($dest."/test$c.txt" , implode($arrayUrls,","));

		for ($c2 = 0; $c2 < count($arrayUrlsClean); $c2++) {
			list(, $urlLocal) = explode("/data/", $arrayUrlsClean[$c2]);

			$arrayExt = explode(".", $arrayUrlsClean[$c2]);
			$ext = array_pop($arrayExt);

			$newfile = "output$global_counter.$ext";

			$data[$c] = str_replace($arrayUrlsClean[$c2], $newfile, $data[$c]);

			$ifile = $dest . "/" . $newfile;

			@copy("../data/$urlLocal", $ifile);

			$global_counter++;
		}

		$writer = new ExportTemplateSVG($dest . "/page$c.svg", $data[$c]);
		$writer->write();
	}

	$output['message'] = "i.Exported";
	$output['pages'] = count($data);
	$output["status"] = 1;
	$output["filedir"] = $filedir;
} else {
	$output['message'] = "i.NoExportFormat";
	$output["status"] = 0;
}


echo json_encode($output, $jsonEncMode);
