<?php
include "headers.inc.php";
session_start(); if (!isset($_SESSION['loggedin'])) {echo '[]'; exit;}
include "functions.inc.php";
include "../assets/config/config.php";
include $canvasDirFromAdmin."/assets/config/config.php";

$output = ["status" => 0];

$_POST = json_decode(file_get_contents("php://input"), true);


//TABLES SET NAMES
$images = $tableNames['images'];
$image_groups = $tableNames['image_groups'];

//VARS SET NAMES
$method = $_POST['method'];

try {
  $pdo = new PDO('mysql:host='.$pdohost.';dbname='.$pdobase.';charset=utf8', $pdouser, $pdopass);
} catch (PDOException $e) {
  $output['syserror']=$e->getMessage();
  $output['message']="PDO connection error";
}

if (isset($pdo)) {
  
  if ($method == "importSqlBasic") {
    $importResult = importSqlFile($pdo, $canvasDirFromAdmin."data/sql/basicdata1.sql");
    $output=$importResult; 
    if ($importResult['status']) {
      $output["status"] = 1;      
    } else {
      $output["status"] = 0;
    }       
  } elseif ($method == "importSqlImages") {
    $importResult = importSqlFile($pdo, $canvasDirFromAdmin."data/sql/images.sql");
    $output=$importResult; 
    if ($importResult['status']) {
      $output["status"] = 1;      
    } else {
      $output["status"] = 0;
    }   
  } elseif ($method == "importSqlTemplates") {
    $importResult = importSqlFile($pdo, $canvasDirFromAdmin."data/sql/templates.sql");
    $output=$importResult; 
    if ($importResult['status']) {
      $output["status"] = 1;      
    } else {
      $output["status"] = 0;
    }   
  } elseif ($method == "createSqlTables") {
    $importResult = importSqlFile($pdo, $canvasDirFromAdmin."data/sql/structure.sql");
    $output=$importResult; 
    if ($importResult['status']) {
      $output["status"] = 1;      
    } else {
      $output["status"] = 0;
    }    
  } else if ($method == "deleteUnusedImages") {
    $assetsArray = [];
    $bgsArray = [];

    $stmt = $pdo->prepare("SELECT * FROM $images");
    $qa[] = $stmt->execute([$origid]);
    $rc[] = $stmt->rowCount();
    $rows = $stmt->fetchAll();

    foreach ($rows as $row) {
      if ($row['type'] == 'assets') {
        $assetsArray[] = $row['filename'];
      }
      if ($row['type'] == 'backgrounds') {
        $bgsArray[] = $row['filename'];
      }
    }

    $assetsDirs[] = $canvasDirFromAdmin . $assetsDir . "images";
    $assetsDirs[] = $canvasDirFromAdmin . $assetsDir . "thumbs";
    $assetsDirs[] = $canvasDirFromAdmin . $assetsDir . "screens";

    foreach ($assetsDirs as $dir) {
      $files = array_diff(scandir($dir), array('..', '.'));
      foreach ($files as $file) {
        if (!in_array($file, $assetsArray, true)) {
          $output["deletedAssets"][] = $file;
          unlink($dir . "/" . $file);
        }
      }
    }

    $backgroundsDirs[] = $canvasDirFromAdmin . $backgroundsDir . "images";
    $backgroundsDirs[] = $canvasDirFromAdmin . $backgroundsDir . "thumbs";
    $backgroundsDirs[] = $canvasDirFromAdmin . $backgroundsDir . "screens";

    foreach ($backgroundsDirs as $dir) {
      $files = array_diff(scandir($dir), array('..', '.'));
      foreach ($files as $file) {
        if (!in_array($file, $bgsArray, true)) {
          $output["deletedBackgrounds"][] = $file;
          unlink($dir . "/" . $file);
        }
      }
    }


    if (is_array($qa)) {
      if (count($qa) > 0) {
        if (in_array(false, $qa, true) == false)
          $output["status"] = 1;
      }
    }
    $output["lastsql"]=$stmt;
  } 

  
}
echo json_encode($output, $jsonEncMode);
