<?php
include "headers.inc.php";
session_start(); if (!isset($_SESSION['loggedin'])) {echo '[]'; exit;}
include "../assets/config/config.php";
include $canvasDirFromAdmin . "/assets/config/config.php";
include "./functions.inc.php";
include $canvasDirFromAdmin . "/php/classes/class.ExportTemplate.php";


$cmykcolors = json_decode(file_get_contents($canvasDirFromAdmin . "/assets/colors/cmyk-colors.json"), true);
$cmykcolors = $cmykcolors['colors'];
foreach ($cmykcolors as $color) {  $rgbcolors[] = $color['rgb']; }
//var_dump($rgbcolors);
$_POST = json_decode(file_get_contents("php://input"), true);


$output = ["status" => 0];

//TABLES SET NAMES
$templates = $tableNames['templates'];
$canvas = $tableNames['canvas'];
$template_groups = $tableNames['template_groups'];
$products = $tableNames['products'];
$fonts = $tableNames['fonts'];

//VARS SET NAMES
$sessionPost = $_GET['sessionPost'];
if (isset($_SESSION[$sessionPost]) & $_POST == null ) {
  $_POST = $_SESSION[$sessionPost];
}
$groups = $_GET['groups'];
$name = $_POST['name'];
$templateGroupId = $_POST['templateGroupId'];
$id = $_POST['id'];
//$product_id = $_POST['product_id'];
$productId = $_POST['productId'];
$method = $_POST['method'];
$goodId = (isset($id) && $id != 0) ? true : false;
$filedir = $_POST['filedir'];
$data = $_POST['canvas'];



try {
  $pdo = new PDO('mysql:host=' . $pdohost . ';dbname=' . $pdobase . ';charset=utf8', $pdouser, $pdopass);
  // print('mysql:host='.$pdohost.';dbname='.$pdobase.';charset=utf8'. $pdouser. $pdopass);
} catch (PDOException $e) {
  $output['syserror'] = $e->getMessage();
  $output['message'] = "PDO connection error";
}

if (isset($pdo)) {

  if ($groups) {
    if (isset($id) && ($method == "delete")) {
      $stmt = $pdo->prepare("DELETE FROM $template_groups WHERE id=?");
      $qa[] = $stmt->execute([$id]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.GroupDeleted";
    } elseif (isset($name) && ($method == "delete")) {
      $stmt = $pdo->prepare("DELETE FROM $template_groups WHERE name=?");
      $qa[] = $stmt->execute([$name]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.GroupDeletedByName (For Postman Only)";
    } elseif (isset($id) && $method == "visible") {
      $stmt = $pdo->prepare("UPDATE $template_groups SET visible = visible XOR 1 WHERE id =?");
      $qa[] = $stmt->execute([$id]);
      $rc[] = $stmt->rowCount();
    } elseif ($id === 0) {
      $stmt = $pdo->prepare("INSERT INTO $template_groups SET name=?");
      $qa[] = $stmt->execute([$name]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.GroupAdded";
    } else {
      $stmt = $pdo->prepare("UPDATE $template_groups SET name=? WHERE id=?");
      $qa[] = $stmt->execute([$name, $id]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.GroupUpdated";
    }
  } elseif ($goodId && $method == "visible") {
    $stmt = $pdo->prepare("UPDATE $templates SET visible = visible XOR 1 WHERE id =?");
    $qa[] = $stmt->execute([$id]);
    $rc[] = $stmt->rowCount();
  } elseif ($goodId && $method == "publish") {
    $stmt = $pdo->prepare("SELECT repoid FROM $templates WHERE id = ?");
    $qa[] = $stmt->execute([$id]);
    $result = $stmt->fetch();
    if($result[0]!=$id) {$repoid = $id;}else{$repoid=0;}
    $stmt = $pdo->prepare("UPDATE $templates SET repoid = ? WHERE id = ?");
    $qa[] = $stmt->execute([$repoid,$id]);
    $rc[] = $stmt->rowCount();
  } elseif ($goodId && $method == "republish") {
    $stmt = $pdo->prepare("SELECT MAX(id) FROM $templates");
    $qa[] = $stmt->execute([$id]);
    $result = $stmt->fetch();
    $idplus = $result[0] + 1;
    $rc[] = $stmt->rowCount();
    $stmt = $pdo->prepare("UPDATE $templates SET repoid=?, id=? WHERE id = ?");
    $qa[] = $stmt->execute([$idplus, $idplus, $id]);
    $rc[] = $stmt->rowCount();
    $stmt = $pdo->prepare("UPDATE $canvas SET template_id=? WHERE template_id = ?");
    $qa[] = $stmt->execute([$idplus, $id]);
    $rc[] = $stmt->rowCount();
  } elseif ($goodId && $method == "update") {
    $stmt = $pdo->prepare("UPDATE $templates SET template_group_id = ?, product_id=? WHERE id =?");
    $qa[] = $stmt->execute([$templateGroupId, $productId, $id]);
    $rc[] = $stmt->rowCount();
  } elseif ($method == "json-admin") {
    $fullPath = $canvasDirFromAdmin . $templatesDir . $filedir;
    @mkdir($fullPath);
    @mkdir($fullPath . '/images');
    @mkdir($fullPath . '/screens');
    $writer = new ExportTemplateJSON($canvasDirFromAdmin, $templatesDir, $id, $filedir, $data, $pdo, $productId, true);
    $writer->setTables(array("canvas" => $canvas, "templates" => $templates));
    $result = $writer->write();
    $qa = $result['qa'];
    $rc = $result['rc'];
    $stmt = $result['lastsql'];
    // $output["POST"]=[$id, $filedir, $data, $pdo, $productId];  
  } elseif ($method == "png-admin") {
    $fullPath = $canvasDirFromAdmin . $templatesDir . $filedir;
    @mkdir($fullPath);
    $writer = new ExportTemplatePNG($fullPath . "/thumb.png", $data[0], false);
    $result = $writer->write();
    $qa[] = $result['qa'];
    for ($c = 0; $c < count($data); $c++) {
      if (substr($data[$c], 0, 4) == "http" || $data[$c] == "" || substr($data[$c], 0, 2) == "./") {
        continue;
      }
      $writer = new ExportTemplatePNG($fullPath . "/page$c.png", $data[$c], false);
      $result = $writer->write();
      $qa[] = $result['qa'];
    }
  } elseif ($goodId && $method == "check") {
    $stmt = $pdo->prepare("SELECT data FROM $canvas WHERE template_id=?");
    $qa[] = $stmt->execute([$id]);
    $rc[] = $stmt->rowCount();
    $dataArray = $stmt->fetchAll();

    $fontInfo = "";
    $fontAlert = "";
    $svgAlert = "";
    $outlineAlert = "";
    $objectsAlert = "";
    $imigeInfo = "";
    $cmykAlert = "";
    $sizeAlert = "";
    $colorspace = "RGB";
    $colorAlert = "";



    foreach ($dataArray as $data) {
      #Stroke test
      if (strpos($data['data'], '"strokeWidth":-') !== false) {
        $svgAlert = "Minus stroke value";
      }
      if (strpos($data['data'], '"stroke":"transparent"') !== false) {
        $svgAlert = "<div class='alert alert-warning'><strong>Attention!</strong> Transparent stroke!</div>";
      }
      #Font test
      $tmpArray = explode('"fontFamily":"', $data['data']);
      array_shift($tmpArray);
      foreach ($tmpArray as $tmp) {
        list($tmp) = explode('"', $tmp);
        $fontArrayUsed[] = $tmp;
        $fontInfo .= "$tmp, ";
      }
      #Text test
      $tmpArray = explode('"type":"text"', $data['data']);
      array_shift($tmpArray);
      foreach ($tmpArray as $tmp) {
        list($tmp) = explode('}', $tmp);
        if (strpos($tmp, '"stroke":"rgb') !== false | strpos($tmp, '"stroke":"#') !== false) {
          $outlineAlert = "Text outline is not supported!";
        }
      }
      #Complex test
      $tmpArray = explode('"type":', $data['data']);
      if (count($tmpArray) > 100) {
        $objectsAlert = "Complex pages were found with more than 100 objects (".count($tmpArray).")! Slow loading alert!";
      }
      #Color test  //disabled
      // $tmpArray = explode('"fill":"#', $data['data']);
      // array_shift($tmpArray);
      // $tmpArray2 = explode('"stroke":"#', $data['data']);
      // array_shift($tmpArray2);
      // $tmpArray = array_merge($tmpArray, $tmpArray2);
      // foreach ($tmpArray as $tmp) {
      //   list($color) = explode('"', $tmp);
      //   if (!in_array($color, $rgbcolors)) {
      //     $colorAlert = "Unsupported color: #" . $color . "!";
      //   }
      // }
    }

    $stmt = $pdo->prepare("SELECT *  FROM $fonts ORDER BY id");
    $q = $stmt->execute();
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $fontArrayGood=[];
    foreach ($result as $row) {  
      $fontArrayGood[]=$row['name'];
    }

    if (isset($fontArrayUsed)) {
      $goodFonts = 0;
      foreach ($fontArrayUsed as $font0) {
        foreach ($fontArrayGood as $font1) {
          if ($font0 == $font1) {
            $goodFonts++;
            break;
          }
        }
      }
      if ($goodFonts != count($fontArrayUsed)) {
        $fontAlert = "Bad font!";
      }
    }


    $stmt = $pdo->prepare("SELECT $templates.filedir, $templates.pages, $products.width, $products.height, $products.resolution FROM $templates, $products WHERE $products.id=$templates.product_id AND $templates.id=?");

    $qa[] = $stmt->execute([$id]);
    $rc[] = $stmt->rowCount();
    $row = $stmt->fetch();
    $filedir = $row['filedir'];
    $fullPath = $canvasDirFromAdmin . $templatesDir . $filedir;

    $fls = @array_diff(@scandir($fullPath . "/images"), ["..", ".", "thumb.png", "blank_pic_hr.jpg", "blank_pic_vr.jpg", "blank_pic_sq.jpg"]);


    $stmt = $pdo->prepare("UPDATE $templates SET checked = ? WHERE id = ?");

    if (count($fls) > 0) {
      foreach ($fls as $fl) {
        $file = $fullPath . "/images/" . $fl;
        $ext = pathinfo($file, PATHINFO_EXTENSION);
        if (in_array($ext, $allow["bg"]["ext"]) == false) {
          continue;
        }
        if (imageIsCMYK($file)) {
          $cmykAlert = "CMYK colorspace!";
          $colorspace = "CMYK";
        }
        $sizes = getimagesize($file);
        $imigeInfo .= $fl . " (" . $colorspace . ", " . $sizes[0] . "x" . $sizes[1] . "), ";
        $minW = $row["resolution"] / 25.4 * $row["width"] / 3; //TODO: count size in json
        $minH = $row["resolution"] / 25.4 * $row["height"] / 3;//TODO: count size in json
        $minS = round(min($minW, $minH));
        if ($sizes[0] < $minS & $sizes[1] < $minS) {
          $sizeAlert = 'Resolution low in ' . $fl . '! (current:' . $sizes[0] . 'x' . $sizes[1] . ', min:' . $minS . ' px)';
        }
      }
    }

    //$colorAlert disabled always ok
    if ($cmykAlert == "" & $sizeAlert == "" & $fontAlert == "" & $svgAlert == "" & $outlineAlert == "" & $objectsAlert == "" & $colorAlert == "") {
      $qa[] = $stmt->execute([1, $id]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.TemplateQualityIsOk";
      $output["alert"] = $cmykAlert . ' ' . $sizeAlert . ' ' . $fontAlert . ' ' . $svgAlert . ' ' . $outlineAlert . ' ' . $objectsAlert . ' ' . $colorAlert;
    } else {
      $qa[] = $stmt->execute([0, $id]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.TemplateQualityIsLow";
      $output["alert"] = $cmykAlert . ' ' . $sizeAlert . ' ' . $fontAlert . ' ' . $svgAlert . ' ' . $outlineAlert . ' ' . $objectsAlert . ' ' . $colorAlert;
    }
  } /* elseif ($template_group_id && $method == "delete") {

    $stmt = $pdo->prepare("SELECT id,filedir FROM $templates WHERE template_group_id=?");
    $qa[] = $stmt->execute([$template_group_id]);
    $rc[] = $stmt->rowCount();
    $row  = $stmt->fetch();

    $id = $row['id'];
    $filedir = $row['filedir'];
    $fullPath = $canvasDirFromAdmin . $templatesDir . $filedir;

    array_map('unlink', glob("$fullPath/screens/*.*"));
    array_map('unlink', glob("$fullPath/images/*.*"));
    @unlink($fullPath . "/thumb.png");


    rmdir("$fullPath/screens");
    rmdir("$fullPath/images");
    rmdir("$fullPath");

    $stmt = $pdo->prepare("DELETE from $templates WHERE id =?");
    $qa[] = $stmt->execute([$id]);
    $rc[] = $stmt->rowCount();

    $stmt = $pdo->prepare("DELETE from $canvas WHERE template_id =?");
    $qa[] = $stmt->execute([$id]);
    $rc[] = $stmt->rowCount();

    $output["message"] = "i.TemplateDeleted";
  }*/ elseif ($goodId && $method == "delete") {

    $stmt = $pdo->prepare("SELECT filedir FROM $templates WHERE id=?");
    $qa[] = $stmt->execute([$id]);
    $rc[] = $stmt->rowCount();
    $row  = $stmt->fetch();

    $filedir = $row['filedir'];
    $fullPath = $canvasDirFromAdmin . $templatesDir . $filedir;

    array_map('unlink', glob("$fullPath/screens/*.*"));
    array_map('unlink', glob("$fullPath/images/*.*"));
    @unlink($fullPath . "/thumb.png");


    @rmdir("$fullPath/screens");
    @rmdir("$fullPath/images");
    @rmdir("$fullPath");

    $stmt = $pdo->prepare("DELETE from $templates WHERE id =?");
    $qa[] = $stmt->execute([$id]);
    $rc[] = $stmt->rowCount();

    $stmt = $pdo->prepare("DELETE from $canvas WHERE template_id =?");
    $qa[] = $stmt->execute([$id]);
    $rc[] = $stmt->rowCount();

    $output["message"] = "i.TemplateDeleted";
  } elseif ($goodId && $method == "import") {

    $repourl = $updateUrl . "/template2.php?id=" . $id;
    $context = stream_context_create(['http' => array('method' => "GET",    'header' => "Content-Type: application/json; charset=utf-8")]);
    $json = trim(file_get_contents($repourl, false, $context), "\xEF\xBB\xBF");
    $repodata = json_decode($json, true);
    if (json_last_error() !== JSON_ERROR_NONE) {
      $output['json_last_error'] = json_last_error();
    }

    $output['repourl'] = $repourl;
    $output['repodata'] = $repodata;

    if ($repodata) {
      $product_id = $repodata['product_id'];
      $folder = $repodata['filedir'];
      $repoid = $repodata['repoid'];
      $files = $repodata['files'];
      $images = $repodata['images'];
      $screens = $repodata['screens'];
      $pages = $repodata['pages'];

      $filedir = time() . rand();
      $group = 11; //TODO: make 11 group protected in database

      $pdo->beginTransaction();
      $stmt = $pdo->prepare("INSERT INTO $templates SET product_id=?, filedir=?, filename='thumb.png', template_group_id=?, unixtime=?, pages=?, repoid=?");
      $qa[] = $stmt->execute([$product_id, (string) $filedir, $group, time(), count($pages), $repoid]);
      $rc[] = $stmt->rowCount();
      $lastId = $pdo->lastInsertId();
      $pdo->commit();

      $page = 1;
      foreach ($pages as $data) {
        //$data = $page;
        $stmt = $pdo->prepare("INSERT INTO $canvas SET data=?, template_id=?, page=?");
        $data = base64_decode($data);
        $data = str_replace($folder, $filedir, $data);
        $qa[] =  $stmt->execute([$data, $lastId, $page]);
        $page++;
      }

      @mkdir($canvasDirFromAdmin . "data/templates/" . $filedir);
      @mkdir($canvasDirFromAdmin .  "data/templates/" . $filedir . "/images/");
      @mkdir($canvasDirFromAdmin . "data/templates/" . $filedir . "/screens/");

      foreach ($files as $file) {
        $img = file_get_contents($updateUrl . "/data/templates/" . $folder . "/" . $file);
        file_put_contents($canvasDirFromAdmin . "data/templates/" . $filedir . "/" . $file, $img);
      }

      foreach ($images as $file) {
        $img = file_get_contents($updateUrl . "/data/templates/" . $folder . "/images/" . $file);
        file_put_contents($canvasDirFromAdmin . "data/templates/" . $filedir . "/images/" . $file, $img);
      }

      foreach ($screens as $file) {
        $img = file_get_contents($updateUrl . "/data/templates/" . $folder . "/screens/" . $file);
        file_put_contents($canvasDirFromAdmin . "data/templates/" . $filedir . "/screens/" . $file, $img);
      }
    }
  } elseif ($goodId && $method == "duplicate") {
    $stmt1 = $pdo->prepare("SELECT product_id, filedir FROM $templates WHERE id=?");
    $qa[] = $stmt1->execute([$id]);
    $stmt2 = $pdo->prepare("SELECT data FROM $canvas WHERE template_id=? ORDER  BY page");
    $qa[] = $stmt2->execute([$id]);

    $dupresult1 = $stmt1->fetch();
    $dupresult2 = $stmt2->fetchAll();

    $productId = $dupresult1['product_id'];
    $filedir = $dupresult1['filedir'];
    $unique = mt_rand();

    $sourcetDir = $canvasDirFromAdmin . $templatesDir . $filedir . "/";
    $targetDir = $canvasDirFromAdmin . $templatesDir . $unique . "/";

    foreach ($dupresult2 as $row) {
      $data[] = $row['data'];
    }


    @mkdir($targetDir);

    if (isset($filedir)) {
      xcopy($sourcetDir, $targetDir);
    }

    $testarray =  array($canvasDirFromAdmin, $templatesDir, null, $unique, $data, $pdo, $productId, true);
    $output["testarray"] = $testarray;
    $writer = new ExportTemplateJSON($canvasDirFromAdmin, $templatesDir, null, $unique, $data, $pdo, $productId, true);
    //$writer = new ExportTemplateJSON(null, $unique, $canvasArray, $pdo, $product_id, true);
    //$writer->setGroup(1);
    //$writer->setRoot($root);
    //$writer->setTemplatesDir($templatesDir);
    //$writer->setOptScreenSize($optScreenSize);
    //$writer->setTables($tableNames);
    $writer->setTables(array("canvas" => $canvas, "templates" => $templates));
    $writer->write();
  }


  if (is_array($qa)) {
    if (count($qa) > 0) {
      if (in_array(false, $qa, true) == false)
        $output["status"] = 1;
    }
  }

  $output["lastsql"] = $stmt;
  $output["qa"] = $qa;
  $output["rc"] = $rc;
  $output["message"] = isset($output["message"]) ? $output["message"] : "i.Done";
}
echo json_encode($output, $jsonEncMode);
