<?php
include "headers.inc.php";
session_start(); if (!isset($_SESSION['loggedin'])) {echo '[]'; exit;}
include "../assets/config/config.php";
include $canvasDirFromAdmin."/assets/config/config.php";

$output = ["status" => 0];



//TABLES SET NAMES
$products = $tableNames['products'];
$product_groups = $tableNames['product_groups'];


//VARS SET NAMES
$file = $_FILES["newfile"];
$id=$_POST["id"];
$type=$_POST["type"];
$tmp_name = $file["tmp_name"];
$groups = $_GET['groups'];
$error = $file["error"];
$name = basename($file["name"]);
$path_parts = pathinfo($name);        
$newfilename = mt_rand().".".$path_parts['extension'];

if ($groups) {
  $newfiledir = $canvasDirFromAdmin . "data/productgroups/";
} else {
  if($type=="icon"){
    $newfiledir = $canvasDirFromAdmin . "data/products/";
  }
  elseif($type=="background"){
    $newfiledir = $canvasDirFromAdmin . "data/productbackgrounds/";
  }  
  elseif($type=="overlay"){
    $newfiledir = $canvasDirFromAdmin . "data/productoverlays/";
  }   
  else{       
    $output["status"]=0;
    $output["message"] = "i.NoImageType";
    exit(json_encode($output, JSON_UNESCAPED_UNICODE));
  }
}


try {
  $pdo = new PDO('mysql:host='.$pdohost.';dbname='.$pdobase.';charset=utf8', $pdouser, $pdopass);
} catch (PDOException $e) {
  $output['syserror']=$e->getMessage();
  $output['message']="PDO connection error";
}

if (isset($pdo)) {
  if (isset($file) && isset($newfiledir) && isset($id)) {

    if ($error > 0) {
      $output["status"] = 0;
      $output["message"] = "i.ErrorUploadingTheFile!";
    } elseif (!($path_parts['extension'] == "jpeg" | $path_parts['extension'] == "jpg" | $path_parts['extension'] == "png" | $path_parts['extension'] == "svg")) {
      $output["status"] = 0;
      $output["message"] = "i.BadFileExtension!";
    } else {
      if (move_uploaded_file($tmp_name, $newfiledir . $newfilename)) {

        if ($groups) {
          $stmt = $pdo->prepare("UPDATE $product_groups SET icon=? WHERE id=?");
        } else {
          if($type=="icon"){
            $stmt = $pdo->prepare("UPDATE $products SET icon=? WHERE id=?");
          }
          elseif($type=="background"){
            $stmt = $pdo->prepare("UPDATE $products SET background=? WHERE id=?");
          }
          elseif($type=="overlay"){
            $stmt = $pdo->prepare("UPDATE $products SET overlay=? WHERE id=?");
          }          
        }


        $q = $stmt->execute([$newfilename, $id]);
        $rc[] = $stmt->rowCount();

        $output["status"] = 1;
        $output["message"] = "i.FileUploadedSuccessfully";
        $output["lastsql"] = $stmt;
      } else {
        $output["status"] = 0;
        $output["message"] = "i.ErrorUploadingTheFile!";
      }
    }
  }


  $output["message"] = isset($output["message"]) ? $output["message"] : "i.Done";
  $output["status"] = ($q) ? $output["status"] : 0;
  $output["rc"] = $rc;
}

echo json_encode($output, $jsonEncMode);
?>