<?php
include "csvheaders.inc.php";
session_start(); if (!isset($_SESSION['loggedin'])) {echo '[]'; exit;}
include "../assets/config/config.php";
include $canvasDirFromAdmin . "/assets/config/config.php";
include "functions.inc.php";


//TABLES SET NAMES
$price_rows    = $tableNames['price_rows'];
$price_cells   = $tableNames['price_cells'];
$price_options = $tableNames['price_options'];
$price_selects = $tableNames['price_selects'];

//VARS SET NAMES
$productId = $_GET["productId"];
$index = 0;
$sep = $csvSeparator;

try {
	$pdo = new PDO('mysql:host=' . $pdohost . ';dbname=' . $pdobase . ';charset=utf8', $pdouser, $pdopass);
} catch (PDOException $e) {
	//$output['syserror'] = $e->getMessage();
	//$output['message'] = "PDO connection error";
}

if (isset($pdo)) {

	if (isset($productId)) {


		$stmt = $pdo->prepare("SELECT *  FROM $price_rows WHERE product_id=? ORDER BY id");
		$q = $stmt->execute([$productId]);
		$result = $stmt->fetchAll(PDO::FETCH_ASSOC);

		foreach ($result as $row) {
			foreach ($row as $key => $value) {
				$output[$index][underToCamel($key)] = $value;
			}
			$stmt = $pdo->prepare("SELECT *  FROM $price_cells WHERE price_row_id=? ORDER BY id");
			$q = $stmt->execute([$row['id']]);
			$result2 = $stmt->fetchAll(PDO::FETCH_ASSOC);
			foreach ($result2 as $row2) {
				$output[$index]['priceArray'][$row2['columnid']] = $row2['price'];
			}
			$index++;
		}


		$stmt = $pdo->prepare("SELECT COUNT($price_options.id) as count, $price_selects.id, $price_selects.name  FROM $price_options, $price_selects 
                          WHERE $price_selects.product_id=? AND  $price_selects.id=$price_options.price_select_id
                          GROUP BY $price_selects.id ORDER BY $price_selects.sortid, $price_selects.id");
		$q = $stmt->execute([$productId]);
		$result = $stmt->fetchAll(PDO::FETCH_ASSOC);

		foreach ($result as $rowSelects) {
			$stmt = $pdo->prepare("SELECT name FROM $price_options WHERE $price_options.price_select_id=? ORDER BY $price_options.sortid, $price_options.id");
			$q = $stmt->execute([$rowSelects['id']]);
			$result2 = $stmt->fetchAll(PDO::FETCH_ASSOC);
			$headers[] = $rowSelects;
			$resultArray[] = $result2;
			$result1CountArray[] = $rowSelects['count'];
		}

		if ($result1CountArray) {
			$addressArray = [];
			$addressArrayCurrent =  array_fill(0, count($result1CountArray), 0);

			$currentLevel = 0;
			if (count($result1CountArray) > 0) {
				for ($с = 0; $c < array_product($result1CountArray); $c++) {
					$addressArray[] = $addressArrayCurrent;
					while ($addressArrayCurrent[$currentLevel] > $result1CountArray[$currentLevel] - 2) {
						$addressArrayCurrent[$currentLevel] = 0;
						$currentLevel++;
					}
					$addressArrayCurrent[$currentLevel]++;
					$currentLevel = 0;
				}
			}

			for ($d = 0; $d < array_product($result1CountArray); $d++) {
				unset($combinationArray);
				$addressArrayCurrent = $addressArray[$d];
				$level = 0;
				foreach ($resultArray as $tmp) {
					$combinationArray[] = $tmp[$addressArrayCurrent[$level]]['name'];
					$level++;
				}
				$rowHeader[] = implode($sep, $combinationArray);
			}
		}


		$csvdata .= "ID" . $sep;
		for ($i = 0; $i < count($headers); $i++) {
			$csvdata .= $headers[$i]['name'] . $sep;
		}
		for ($i = 0; $i < count($output); $i++) {
			$csvdata .= "К-во:Срок:Цена" . $sep;
		}
		$csvdata .= "\r\n";


		for ($i = 0; $i < count($headers) + 1; $i++) {
			$csvdata .= $sep;
		}
		for ($i = 0; $i < count($output); $i++) {
			$csvdata .= $output[$i]['number'] . $sep;
		}
		$csvdata .= "\r\n";


		for ($i = 0; $i < count($headers) + 1; $i++) {
			$csvdata .= $sep;
		}
		for ($i = 0; $i < count($output); $i++) {
			$csvdata .= $output[$i]['period'] . $sep;
		}
		$csvdata .= "\r\n";

		for ($i = 0; $i < count($output[0]['priceArray']); $i++) {
			$csvdata .= "price" . ($i + 1) . $sep . $rowHeader[$i] . $sep;

			for ($j = 0; $j < count($output); $j++) {
				$csvdata .= $output[$j]['priceArray'][$i] . $sep;
			}
			$csvdata .= "\r\n";
		}
	}
}

echo $csvdata;
