<?php
function underToCamel($string) {
    $str = str_replace('_', '', ucwords($string, '_'));
    $str = lcfirst($str);
    return $str;
}

function camelToUnder($string)
{
    if (preg_match('/[A-Z]/', $string) === 0) {
        return $string;
    }
    $pattern = '/([a-z])([A-Z])/';
    $string = strtolower(preg_replace_callback($pattern, function ($a) {
        return $a[1] . "_" . strtolower($a[2]);
    }, $string));
    return $string;
}

function writeImageResized($orimage, $sizelimit, $targetimage, $isSquare=false){
	
	$path_parts = pathinfo($orimage);	

	list($width_orig, $height_orig) = @getimagesize($orimage);
	
	$small_width=$sizelimit;						
	
	if($isSquare){
		if($height_orig>$width_orig){
			$height = $sizelimit;
			$width  = 	$height*$width_orig/$height_orig;
			$x = ($height-$width)/2;
			$y=0;
		}else{
			$width=$sizelimit;
			$height  = 	$width*$height_orig/$width_orig;
			$x=0;
			$y=($width-$height)/2;
		}
		$small_height=$sizelimit;
	}
	else{
		$width=$sizelimit;
		$height=$height_orig*$small_width/$width_orig;	
		$x=0;
		$y=0;
		$small_height=$small_width*$height_orig/$width_orig;
	}

		
	$smallIm=imagecreatetruecolor($small_width, $small_height);
	$backgroundColor = imagecolorallocate($smallIm, 255, 255, 255);
	imagecolortransparent($smallIm, $backgroundColor);
	imagefill($smallIm, 0, 0, $backgroundColor);
		
	if($path_parts['extension'] == 'jpg' | $path_parts['extension'] == 'jpeg'){		
		imagecopyresampled($smallIm, imagecreatefromjpeg($orimage), $x, $y, 0, 0, $width, $height, $width_orig, $height_orig);
		imagejpeg($smallIm,$targetimage, 50);
	}
	if($path_parts['extension'] == 'png'){		
		imagecopyresampled($smallIm, imagecreatefrompng($orimage), $x, $y, 0, 0, $width, $height, $width_orig, $height_orig);
		imagepng($smallIm,$targetimage);
	}	
}			

function writeImageCroped($orimage, $variation, $targetimage){
	
	$width=$variation['width'];
	$height=$variation['height'];
	
	$path_parts = pathinfo($orimage);	

	list($width_orig, $height_orig) = @getimagesize($orimage);	


	$x=($width_orig-$width)/2;
	$y=($height_orig-$height)/2;


		
	$smallIm=imagecreatetruecolor($width, $height);
	$backgroundColor = imagecolorallocate($smallIm, 255, 255, 255);
	imagecolortransparent($smallIm, $backgroundColor);
	imagefill($smallIm, 0, 0, $backgroundColor);
		
	if($path_parts['extension'] == 'jpg' | $path_parts['extension'] == 'jpeg'){		
		imagecopyresampled($smallIm, imagecreatefromjpeg($orimage), 0, 0, $x, $y, $width, $height, $width, $height);
		imagejpeg($smallIm,$targetimage, 50);
	}
	if($path_parts['extension'] == 'png'){		
		imagecopyresampled($smallIm, imagecreatefrompng($orimage), 0, 0, $x, $y, $width, $height, $width, $height);
		imagepng($smallIm,$targetimage);
	}	
}			
	
function xcopy($source, $dest, $permissions = 0755)
{
	if (is_link($source)) {
		return symlink(readlink($source), $dest);
	}

	if (is_file($source)) {
		return copy($source, $dest);
	}

	if (!is_dir($dest)) {
		mkdir($dest, $permissions);
	}

	$dir = dir($source);
	while (false !== $entry = $dir->read()) {
		if ($entry == '.' || $entry == '..') {
			continue;
		}

		xcopy("$source/$entry", "$dest/$entry", $permissions);
	}

	$dir->close();
	return true;
}		


function importSqlFile($pdo, $sqlFile, $tablePrefix = null, $InFilePath = null){
	$output = [];
	$rc=[];
	try {
		
		if(!file_exists($sqlFile)) {
			$output['status']= false;
			$output['message']= "i.NoSqlFile";
			return $output;
		}	
		
		$pdo->setAttribute(\PDO::MYSQL_ATTR_LOCAL_INFILE, true);		
		$errorDetect = false;
		$output['rc']=0;	
		$output['skipped']=0;	
		$output['lines']=0;
		$output['requests']=0;
		$tmpLine = '';		
		$lines = file($sqlFile);
		
		foreach ($lines as $line) {
			$output['lines']++;
			if (substr($line, 0, 2) == '--' || substr($line, 0, 2) == '/*' || trim($line) == '') {
				continue;
				$output['skipped']++;
			}
			
			$line = str_replace(['<<prefix>>', '<<InFilePath>>'], [$tablePrefix, $InFilePath], $line);
			// $line = str_replace("`", '', $line);
			$line = str_replace("\n", '', $line);
			$tmpLine .= $line;

			if (substr(trim($line), -1, 1) == ';') {
				try {
					$rc = $pdo->exec($tmpLine);
					$output['rc'] += $rc;
				} catch (\PDOException $e) {
					$output['message'] =  "Error performing Query: '" . $tmpLine . "': " . $e->getMessage();
					$errorDetect = true;
				}
				$output['requests']++;
				$output["lastsql"] = $tmpLine;
				$tmpLine = '';
			}
		}
		
		if ($errorDetect) {
			$output['status']= false;
			return $output;
		}
		
	} catch (\Exception $e) {
		$output['status']= false;
		$output['message']= "Exception => " . $e->getMessage();
		return $output;
	}

	$output['status']= true;
	$output['message']= "i.Imported";
	return $output;
}

function imageIsCMYK($path) {
    $t = getimagesize($path);
    if (array_key_exists('mime', $t) and 'image/jpeg' == $t['mime']) {
        if (array_key_exists('channels', $t) and 4 == $t['channels']) {
            return true;
        }
    }
    return false;
}
