<?php
class GalleryReadDir extends GalleryRead
{
	public function __construct($idir)
	{
	   $this->idir=$idir;	   	   
	}	
	
	protected  function read($ratio=0, $presision=0)
	{
		$gallery=new Gallery();
		$filesDirs = scandir($this->idir);
		$filesDirs=array_diff( $filesDirs, [".",".."] );	
		foreach($filesDirs as $entry) {  if(is_file($this->idir."/".$entry)){$files[] = $entry;} }	
		if(!isset($files)){return $gallery;}
		sort($files);
		$gallery->addFiles($files);
		$gallery->SetGroup("import");
		$gallery->SetPath($this->idir);
		return ($gallery);
	}
}

class GalleryReadTemplatesSql extends GalleryRead
{
	private $pdo=null;
	private $product=1;
	private $tableNames=array('template_groups'=>'template_groups', 'templates'=>'templates');
	
	public function __construct($pdo, $product)
	{
		 $this->pdo = $pdo; 
		 $this->product = $product; 
	}		
	
	public function setTableNames ($tableNames)
	{	
		foreach ($tableNames as $key=>$value)
		{
			/// if(!ctype_alnum(str_replace("_","",$value)))  {exit("00");}
			$this->tableNames[$key]=$value;
		}
	}	
	
	 protected  function read($ratio=0, $presision=0)
	 {
		$gallery=new Gallery();
		
		$template_groups=$this->tableNames['template_groups'];
		$templates=$this->tableNames['templates'];
		$products=$this->tableNames['products'];
		
		$stmt = $this->pdo->prepare("SELECT templatelink  FROM $products WHERE id=?");		
		$stmt->execute([$this->product]);
		$result=$stmt->fetch();			
		
		$oriProductId = $this->product;
		
		$this->product=($result['templatelink']==0)?$this->product:$result['templatelink'];
		
		$stmt = $this->pdo->prepare("SELECT $templates.id, $templates.filedir, $templates.filename, $template_groups.name, template_group_id  FROM $templates, $template_groups 
		WHERE $template_groups.id=$templates.template_group_id AND $templates.product_id=? AND $templates.visible=1 ORDER BY template_group_id");
		//echo "SELECT $templates.id, $templates.filedir, $templates.filename, $template_groups.name, template_group_id  FROM $templates, $template_groups 
		//WHERE $template_groups.id=$templates.template_group_id AND $templates.product_id=? AND $templates.visible=1 ORDER BY template_group_id";

		$stmt->execute([$this->product]);
		$result=$stmt->fetchAll();		
		
		foreach($result as $row)
		{
			$gallery->addFileWithIdPreview($row["id"],  $row["id"],  $row["filedir"]."/".$row["filename"]);
			$gallery->SetGroupById($row["id"],$row["name"]);
			$gallery->SetGroupIdById($row["id"],$row["template_group_id"]);
			$gallery->setOriProductId($oriProductId);
		}	
		
		return ($gallery);
	 }
}

class GalleryReadProductGroupsSql extends GalleryRead {
	
	private $pdo=null;
	
	public function __construct($pdo){
		 $this->pdo = $pdo; 
	}	

	public function setTableNames ($tableNames)	{	
		foreach ($tableNames as $key=>$value){
			$this->tableNames[$key]=$value;
		}
	}	

	protected  function read($ratio=0, $presision=0) {
	$gallery=new Gallery();

	$product_groups=$this->tableNames['product_groups'];
	$products=$this->tableNames['products'];	

	$stmt = $this->pdo->prepare("SELECT $product_groups.id, $product_groups.name, $products.id AS pid, $product_groups.icon  FROM $product_groups, $products
	WHERE $product_groups.visible=1 AND  $product_groups.id=$products.product_group_id GROUP BY $product_groups.id ");
	$stmt->execute();
	$result=$stmt->fetchAll();	


	foreach($result as $row){
		$gallery->addFileWithId($row["id"], $row["icon"], $row["name"]);	
	}	

	return ($gallery);
	}
}

class GalleryReadProductsSql extends GalleryRead {
	
	private $pdo=null;
	private $productGroupId=null;
	
	public function __construct($pdo, $productGroupId){
		 $this->pdo = $pdo; 
		 $this->productGroupId = $productGroupId; 
	}	

	public function setTableNames ($tableNames)
	{	
		foreach ($tableNames as $key=>$value){
			$this->tableNames[$key]=$value;
		}
	}	

	 protected  function read($ratio=0, $presision=0) {
		$gallery=new Gallery();
		
		$products=$this->tableNames['products'];	
		
		if(isset($this->productGroupId)){
			$stmt = $this->pdo->prepare("SELECT *  FROM $products  WHERE visible=1 AND product_group_id=? ORDER BY id ");
			$stmt->execute([$this->productGroupId]);
		}else{
			$stmt = $this->pdo->prepare("SELECT *  FROM $products  WHERE visible=1 ORDER BY id ");
			$stmt->execute();
		}

		$result=$stmt->fetchAll();	
		
		
		foreach($result as $row){
			$gallery->addFileWithId($row["id"], $row["icon"], $row["descr"]);		
		}	

		return ($gallery);
	 }
}


class GalleryReadXml extends GalleryRead
{	
	protected $file;
	
	public function __construct($idir, $file, $filesSub, $thumbsSub, $htmldir)
	{
		$this->idir=$idir;
		$this->htmldir=$htmldir;	   
		$this->file=$file;	
		$this->filesSub=$filesSub;	   
		$this->thumbsSub=$thumbsSub;				
	}	 
	
	protected  function read($ratio=0, $presision=0)
	{	 
		$gallery=new Gallery();
		$xml=file_get_contents($this->idir.$this->file);
		$xml=simplexml_load_string($xml);	
		$c=0;
		foreach($xml as $node)
		{
			$xml2=file_get_contents($this->idir.$node->folder."/section.xml");
			$xml2=@simplexml_load_string($xml2);
			
			if($xml2===false){continue;}
			if(count($xml2)==0){continue;}

			
			foreach($xml2 as $node2)
			{
				if($ratio!=0){
					$width=$node2->width; $height=$node2->height;
					if($width!=0){
						if($width/$height<$ratio-$presision){continue;}
						if($width/$height>$ratio+$presision){continue;}
					}
				}

				if(!$node2->filename){continue;}
				$gallery->addFileWithIdPreview($c,  $this->filesSub."/".$node2->filename, $this->thumbsSub."/".$node2->thumb_name);
				$gallery->SetGroupById($c,(string)$node->title);
				$gallery->SetGroupIdById($c,(string)$node->folder);
				$gallery->SetPathById($c,$this->htmldir.$node->folder."/");
				$c++;
			}			
		}		
		return ($gallery);
	}
}


abstract class GalleryRead
{
	protected $idir;
	protected $ratio = 0;
	protected $presision = 0.1;
	
	public  function setRatio($ratio)
	{
		$this->ratio = $ratio; 
	}	

	public  function setPresision($presision)
	{
		$this->presision = $presision; 
	}	

	public function getGallery()
	{
		$gallery=$this->read($this->ratio, $this->presision);

		return($gallery);
	}
	
	abstract protected function read();	
}


?>