<?php
class Gallery implements JsonSerializable
{
	private $files = array();
	private $groups = array();

	public function __construct()
	{
	}

	public function toJson()
	{
		$str = json_encode($this);
		$str = str_replace("\/", "/", $str);
		return ($str);
	}

	public function groupsToJson()
	{
		$groups = $this->getGroups();
		$str = json_encode($groups);
		$str = str_replace("\/", "/", $str);
		return ($str);
	}


	public function jsonSerialize()
	{
		$obj['files'] = $this->files;
		$obj['groups'] = $this->getGroups();
		return $obj;
	}

	public function addFile($file)
	{
		$this->files[] = new GalleryObject(count($this->files), $file, $file);
	}

	public function addFileWithPreview($file, $preview)
	{
		$this->files[] = new GalleryObject(count($this->files), $file, $preview);
	}

	public function addFileWithId($id, $file, $name)
	{
		$obj  = new GalleryObject($id, $file, $file);
		$obj->setName($name);
		$this->files[] = $obj;
	}

	public function setGroupById($id, $group)
	{
		for ($c = 0; $c < count($this->files); $c++) {
			if ($id == $this->files[$c]->id) {
				$this->files[$c]->group = $group;
			}
		}
	}


	public function countGroups()
	{
		$testArray = array();
		for ($c = 0; $c < count($this->files); $c++) {
			if (in_array($this->files[$c]->group, $testArray) == false) {
				$testArray[] = $this->files[$c]->group;
			}
		}
		return (count($testArray));
	}

	public function setGroupIdById($id, $group)
	{
		for ($c = 0; $c < count($this->files); $c++) {
			if ($id == $this->files[$c]->id) {
				$this->files[$c]->groupId = $group;
			}
		}
	}


	public function addFileWithIdPreview($id, $file, $preview)
	{
		$this->files[] = new GalleryObject($id, $file, $preview);
	}

	public function addFiles($files)
	{
		foreach ($files as $file) {
			$this->files[] = new GalleryObject(count($this->files), $file, $file);
		}
	}

	public function __toString()
	{
		return (serialize($this->files));
	}

	public function getBurlList()
	{
		foreach ($this->files as $file) {
			$urls[] = $file->burl;
		}
		if (isset($urls)) {
			return $urls;
		}
	}

	public function setPath($path)
	{
		for ($c = 0; $c < count($this->files); $c++) {
			$this->files[$c]->path = $path;
		}
	}


	public function setGroup($group)
	{
		for ($c = 0; $c < count($this->files); $c++) {
			$this->files[$c]->group = $group;
		}
	}

	public function getGroups()
	{
		$groups = array();
		for ($c = 0; $c < count($this->files); $c++) {
			if (in_array($this->files[$c]->group, $groups) == false) {
				$groups[$this->files[$c]->groupId] = $this->files[$c]->group;
			}
		}
		return $groups;
	}


	public function setPathById($id, $path)
	{
		for ($c = 0; $c < count($this->files); $c++) {
			if ($id == $this->files[$c]->id) {
				$this->files[$c]->path = $path;
			}
		}
	}

	public function getFullBurlById($id)
	{
		for ($c = 0; $c < count($this->files); $c++) {
			if ($id == $this->files[$c]->id) {
				return ($this->files[$c]->path . $this->files[$c]->burl);
			}
		}
	}


	public function getFullList()
	{
		return $this->files;
	}

	public function setOriProductId($id)
	{
		for ($c = 0; $c < count($this->files); $c++) {
			$this->files[$c]->oriProductId = $id;
		}
	}
}



class GalleryObject implements JsonSerializable
{
	public $id;
	public $burl;
	public $surl;
	public $path;
	public $group = "popular";
	public $groupId = 0;
	public $subGroup = "none";
	public $oriProductId = 0;
	public $name = "";

	public function __construct($id, $burl, $surl)
	{
		$this->id = $id;
		$this->burl = $burl;
		$this->surl = $surl;
	}

	public function setName($name)
	{
		$this->name = $name;
	}


	public function jsonSerialize()
	{
		$obj['id'] = $this->id;
		$obj['burl'] = $this->burl;
		$obj['surl'] = $this->surl;
		$obj['group']  = $this->group;
		$obj['groupId']  = $this->groupId;
		$obj['path']  = $this->path;
		$obj['oriProductId']  = $this->oriProductId;
		return $obj;
	}
}
