<?php
include "headers.inc.php";
include "functions.inc.php";
include "../assets/config/config.php";
include $canvasDirFromCalc . "/assets/config/config.php";
$output = [];
//session_start();
$index = 0;


//TABLES SET NAMES
$price_rows = $tableNames['price_rows'];
$price_cells = $tableNames['price_cells'];
$price_options = $tableNames['price_options'];
$price_selects = $tableNames['price_selects'];


//VARS SET NAMES
$productId = $_GET["productId"];
$priceSelectId = $_GET["priceSelectId"];
$selects = $_GET['selects'];
$options = $_GET['options'];
$selectsWithOptions = $_GET['selectsWithOptions'];

try {
  $pdo = new PDO('mysql:host=' . $pdohost . ';dbname=' . $pdobase . ';charset=utf8', $pdouser, $pdopass);
} catch (PDOException $e) {
  $output['syserror'] = $e->getMessage();
  $output['message'] = "PDO connection error";
}

if (isset($pdo)) {

  if ($_GET["headers"]) {


    $stmt = $pdo->prepare("SELECT COUNT($price_options.id) as count, $price_selects.id, $price_selects.name  FROM $price_options, $price_selects 
                          WHERE $price_selects.product_id=? AND  $price_selects.id=$price_options.price_select_id
                          GROUP BY $price_selects.id ORDER BY $price_selects.sortid, $price_selects.id");
    $q = $stmt->execute([$productId]);
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($result as $row) {
      $stmt = $pdo->prepare("SELECT name FROM $price_options WHERE $price_options.price_select_id=? ORDER BY $price_options.sortid, $price_options.id");
      $q = $stmt->execute([$row['id']]);
      $result2 = $stmt->fetchAll(PDO::FETCH_ASSOC);
      $result2Array[] = $result2;
      $result1CountArray[] = $row['count'];
    }

    if ($result1CountArray) {
      $addressArray = [];
      $addressArrayLimit = $result1CountArray;
      $addressArrayCurrent =  array_fill(0, count($result1CountArray), 0);

      $currentLevel = 0;
      if (count($addressArrayLimit) > 0) {
        for ($с = 0; $c < array_product($addressArrayLimit); $c++) {
          $addressArray[] = $addressArrayCurrent;
          while ($addressArrayCurrent[$currentLevel] > $addressArrayLimit[$currentLevel] - 2) {
            $addressArrayCurrent[$currentLevel] = 0;
            $currentLevel++;
          }
          $addressArrayCurrent[$currentLevel]++;
          $currentLevel = 0;
        }
      }

      for ($d = 0; $d < array_product($result1CountArray); $d++) {
        unset($combinationArray);
        $addressArrayCurrent = $addressArray[$d];
        $level = 0;
        foreach ($result2Array as $tmp) {
          $combinationArray[] = $tmp[$addressArrayCurrent[$level]]['name'];
          $level++;
        }
        $combination = implode("|", $combinationArray);
        $output[] = ["columnid"  => $d, "name" => $combination];
      }
    }
  } elseif ($selects) {

    $stmt = $pdo->prepare("SELECT * FROM $price_selects WHERE product_id=? ORDER BY sortid");
    $q = $stmt->execute([$productId]);
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($result as $row) {
      foreach ($row as $key => $value) {
        $output[$index][underToCamel($key)] = $value;
      }
      $index++;
    }
  } elseif ($selectsWithOptions) {
    $stmt = $pdo->prepare("SELECT * FROM $price_selects WHERE product_id=? ORDER BY sortid");
    $q = $stmt->execute([$productId]);
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);


    foreach ($result as $row) {
      foreach ($row as $key => $value) {
        $output[$index][underToCamel($key)] = $value;
      }

      $index2 = 0;
      $stmt = $pdo->prepare("SELECT * FROM $price_options WHERE price_select_id=? ORDER BY sortid");
      $q = $stmt->execute([$row['id']]);
      $result2 = $stmt->fetchAll(PDO::FETCH_ASSOC);

      foreach ($result2 as $row) {
        foreach ($row as $key => $value) {
          $output[$index]['options'][$index2][underToCamel($key)] = $value;
        }
        $index2++;
      }      

      $index++;
    }
  } elseif ($options) {

    $stmt = $pdo->prepare("SELECT * FROM $price_options WHERE price_select_id=? ORDER BY sortid");
    $q = $stmt->execute([$priceSelectId]);
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($result as $row) {
      foreach ($row as $key => $value) {
        $output[$index][underToCamel($key)] = $value;
      }
      $index++;
    }
  } else {

    $stmt = $pdo->prepare("SELECT *  FROM $price_rows WHERE product_id=? ORDER BY id");
    $q = $stmt->execute([$productId]);
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($result as $row) {
      foreach ($row as $key => $value) {
        $output[$index][underToCamel($key)] = $value;
      }
      $stmt = $pdo->prepare("SELECT *  FROM $price_cells WHERE price_row_id=? ORDER BY id");
      $q = $stmt->execute([$row['id']]);
      $result2 = $stmt->fetchAll(PDO::FETCH_ASSOC);
      foreach ($result2 as $row2) {
        $output[$index]['priceArray'][$row2['columnid']] = $row2['price'];
      }
      $index++;
    }
  }
}


echo json_encode($output, $jsonEncMode);
