<?php
function underToCamel($string) {
    $str = str_replace('_', '', ucwords($string, '_'));
    $str = lcfirst($str);
    return $str;
}

function camelToUnder($string){
    if (preg_match('/[A-Z]/', $string) === 0) {
        return $string;
    }
    $pattern = '/([a-z])([A-Z])/';
    $string = strtolower(preg_replace_callback($pattern, function ($a) {
        return $a[1] . "_" . strtolower($a[2]);
    }, $string));
    return $string;
}

function sanitizePdo($table){
	if(!ctype_alnum(str_replace("_","",$table))){throw new Exception('Table name error:'.$table);return null;}else{return $table;}
}
?>
