<?php

class ExportTemplateJSON extends ExportTemplate
{
	private $pdo = null;
	private $id = null;
	private $fileDir = null;
	private $productId = null;
	private $group = 1;
	private $isCopyImages = false;
	private $tableNames = array("canvas" => "canvas", "templates" => "templates");
	private $templatesDir = "data/templates/";
	private $root = "../canvas/";
	private $optScreen = 1024;


	public function __construct($root, $templatesDir, $id, $fileDir, $data, $pdo, $productId = null, $isCopyImages = false)
	{
		$this->root         = $root;
		$this->templatesDir = $templatesDir;
		$this->id           = $id;
		$this->pdo          = $pdo;
		$this->fileDir      = $fileDir;
		$this->productId    = $productId;
		$this->data         = $data;
		$this->isCopyImages = $isCopyImages;
	}

	public function setOptScreenSize($optScreen)
	{
		$this->optScreen = $optScreen;
	}

	public function setTables($tableNames)
	{
		$this->tableNames["canvas"] = $tableNames["canvas"];
		$this->tableNames["templates"] = $tableNames["templates"];
	}

	public function setTemplatesDir($templatesDir)
	{
		$this->templatesDir = $templatesDir;
	}

	public function setGroup($group)
	{
		$this->group = $group;
	}

	public function setRoot($root)
	{
		$this->root = $root;
	}

	public static function fixData($data)
	{
		$data = str_replace('\\\n', '\n',  $data);
		$data = str_replace('\r\n', '\n',  $data);		
		$data = str_replace('\\\"', '"',  $data);
		$data = str_replace('\\"', '&quot;',  $data);
		$data = str_replace('\"', '"',  $data);

		if (strpos($data, "http") != false) {
			$array = explode("http", $data);
			foreach ($array as $str) {
				if (strpos($str, "data/") != false) {
					list($find) = explode("data/", $str);
					$find = "http" . $find;
					$data = str_replace($find, "", $data);
				}
			}
		}

		return $data;
	}


	public static function getImageUrls($data)
	{
		$arrayUrlsClean = array();
		$arrayUrls	= explode("data/", $data);

		for ($c2 = 1; $c2 < count($arrayUrls); $c2++) {
			list($url) = explode('"', $arrayUrls[$c2]);
			if (!in_array("data/" . $url, $arrayUrlsClean)) {
				$arrayUrlsClean[] = "data/" . $url;
			}
		}

		$arrayUrls	= explode("data:", $data);

		for ($c2 = 1; $c2 < count($arrayUrls); $c2++) {
			list($url) = explode('"', $arrayUrls[$c2]);
			if (!in_array("data:" . $url, $arrayUrlsClean)) {
				$arrayUrlsClean[] = "data:" . $url;
			}
		}

		return $arrayUrlsClean;
	}


	public static function imagesFromUrls($arrayUrlsClean)
	{
		$inlineImages = [];

		for ($c2 = 0; $c2 < count($arrayUrlsClean); $c2++) {
			//print $arrayUrlsClean[$c2]."<br><br>";

			$filenameRnd = mt_rand();

			if (substr($arrayUrlsClean[$c2], 0, 15) == 'data:image/jpeg') {
				$filename = "inline" . $filenameRnd . ".jpg";
				$inlineImages[] = ['file' => $filename, 'data' => $arrayUrlsClean[$c2]];
			}
			if (substr($arrayUrlsClean[$c2], 0, 14) == 'data:image/png') {
				$filename = "inline" . $filenameRnd . ".png";
				$inlineImages[] = ['file' => $filename, 'data' => $arrayUrlsClean[$c2]];
			}
			if (substr($arrayUrlsClean[$c2], 0, 14) == 'data:image/gif') {
				$filename = "inline" . $filenameRnd . ".gif";
				$inlineImages[] = ['file' => $filename, 'data' => $arrayUrlsClean[$c2]];
			}
		}

		return $inlineImages;
	}


	public static function fixImageUrls($data, $arrayUrlsClean, $root, $targetDir, $inlineFiles)
	{
		//PART1
		foreach ($inlineFiles as $infile) { //BE-FO-RE PART2
			//file_put_contents($root . $targetDir . "../screens/" . $infile['file'].".txt", $infile['data']);//for test
			$data = str_replace($infile['data'], $targetDir . $infile['file'], $data);
		}
		//PART2
		for ($c2 = 0; $c2 < count($arrayUrlsClean); $c2++) {
			$file = basename($arrayUrlsClean[$c2]);
			// echo  "data/" . $arrayUrlsClean[$c2]."|";
			// $data = str_replace("data//", "data/", $data);
			$data = str_replace($root . "data/" . $arrayUrlsClean[$c2], $targetDir . $file, $data); //TRY TO REMOVE
			$data = str_replace("data/" . $arrayUrlsClean[$c2], $targetDir . $file, $data); //TRY TO REMOVE
			$data = str_replace($arrayUrlsClean[$c2], $targetDir . $file, $data);
		}

		return $data;
	}

	//TODO
	//изменение размера изображений
	public static function createImages($usedFiles, $root, $targetDir, $resize = false)
	{
		@mkdir($root . $targetDir, 0777, true);

		for ($c2 = 0; $c2 < count($usedFiles); $c2++) {
			file_put_contents($root . $targetDir  . $usedFiles[$c2]['file'], file_get_contents($usedFiles[$c2]['data']));
		}
	}


	public static function copyImages($usedFiles, $root, $targetDir, $resize = false)
	{
		// $usedFiles2 = [];
		@mkdir($root . $targetDir, 0777, true);


		for ($c2 = 0; $c2 < count($usedFiles); $c2++) {
			$file = basename($usedFiles[$c2]);
			if ($resize != false) {
				if (substr($file, -3) == 'jpg' || substr($file, -4) == 'jpeg' || substr($file, -3) == 'png') {
					list($width_orig, $height_orig) = @getimagesize($root .  $usedFiles[$c2]);
					if ($resize < $width_orig) {
						$medium_width = $resize;
						$medium_height = $height_orig * $resize / $width_orig;
						$mediumIm = imagecreatetruecolor($medium_width, $medium_height);
						$backgroundColor = imagecolorallocate($mediumIm, 255, 255, 255);
						imagecolortransparent($mediumIm, $backgroundColor);
						imagefill($mediumIm, 0, 0, $backgroundColor);
						imagealphablending($mediumIm, false);
						imagesavealpha($mediumIm, true);

						if (substr($file, -3) == 'jpg' || substr($file, -4) == 'jpeg') {
							imagecopyresampled($mediumIm, imagecreatefromjpeg($root .  $usedFiles[$c2]), 0, 0, 0, 0, $medium_width, $medium_height, $width_orig, $height_orig);
							imagejpeg($mediumIm, $root . $targetDir . $file, 50);
						} elseif (substr($file, -3) == 'png') {
							imagecopyresampled($mediumIm, imagecreatefrompng($root . $usedFiles[$c2]), 0, 0, 0, 0, $medium_width, $medium_height, $width_orig, $height_orig);
							imagepng($mediumIm, $root . $targetDir . $file);
						}
					} else {
						@copy($root .  $usedFiles[$c2], $root . $targetDir . $file);
					}
				} else {
					@copy($root .  $usedFiles[$c2], $root . $targetDir . $file);
				}
			} else {
				@copy($root .  $usedFiles[$c2], $root . $targetDir . $file);
			}
			// $usedFiles2[] = $file;
		}
	}


	public static function deleteUnusedFiles($usedFiles, $root, $targetDir)
	{
		$usedFiles2 = [];
		for ($c2 = 0; $c2 < count($usedFiles); $c2++) {
			$usedFiles2[] = basename($usedFiles[$c2]);
		}

		if (is_dir($root . $targetDir)) {
			$unusedFiles  = array_diff(array_diff(scandir($root . $targetDir), ["..", "."]), $usedFiles2);
		}
		if (isset($unusedFiles)) {
			foreach ($unusedFiles as $file) {
				unlink($root . $targetDir . $file);
			}
		}
	}


	public function write()
	{
		$usedFiles = [];
		$inlineArray = [];
		$targetDir0 =       "templates/" . $this->fileDir . "/images/";
		$targetDir = $this->templatesDir . $this->fileDir . "/images/";
		$screenDir = $this->templatesDir . $this->fileDir . "/screens/";

		//file_put_contents($this->root . $screenDir . "write.txt", "ok");//for test

		if ($this->id != 0) {
			$stmt = $this->pdo->prepare("SELECT  EXISTS (SELECT 1 FROM " . $this->tableNames["templates"] . " WHERE id=? LIMIT 1)");
			$stmt->execute([$this->id]);
			$isExists = $stmt->fetch();

			if ($isExists[0] == 1) {
				$stmt = $this->pdo->prepare('UPDATE ' . $this->tableNames["templates"] . ' SET  filedir=?, filename="thumb.png", template_group_id=?, unixtime=?, pages=?, checked=0 WHERE id=?');
				$stmt->execute([(string) $this->fileDir, $this->group, time(), count($this->data), $this->id]);

				$stmt = $this->pdo->prepare("DELETE FROM " . $this->tableNames["canvas"] . "  WHERE  template_id=?");
				$qa[] = $stmt->execute([$this->id]);
				$rc[] = $stmt->rowCount();
			} else {
				$stmt = $this->pdo->prepare('INSERT INTO ' . $this->tableNames["templates"] . ' SET id=?, product_id=?, filedir=?, filename="thumb.png", template_group_id=?, unixtime=?, pages=?, checked=0');
				$qa[] = $stmt->execute([$this->id, $this->productId, (string) $this->fileDir, $this->group, time(), count($this->data)]);
				$rc[] = $stmt->rowCount();
				//file_put_contents("ytut.txt",'INSERT INTO '.$this->tableNames["templates"]." SET id=$this->id, product_id=$this->productId, filedir='$this->fileDir', surl='thumb.png', template_group_id=$this->group, unixtime=".time().", pages=".count($this->data)." ");
			}
		} else {
			$this->pdo->beginTransaction();
			$stmt = $this->pdo->prepare('INSERT INTO ' . $this->tableNames["templates"] . ' SET product_id=?, filedir=?, filename="thumb.png", template_group_id=?, unixtime=?, pages=?, checked=0 ');
			// echo ('INSERT INTO '.$this->tableNames["templates"].' SET product_id='.$this->productId.', filedir='.(string)$this->fileDir.', filename="thumb.png", template_group_id='.$this->group.', unixtime='.time().', pages='.count($this->data).' ');
			$qa[] = $stmt->execute([$this->productId, (string) $this->fileDir, $this->group, time(), count($this->data)]);
			$rc[] = $stmt->rowCount();
			$this->id = $this->pdo->lastInsertId();
			$this->pdo->commit();
		}


		for ($c = 0; $c < count($this->data); $c++) {
			$this->data[$c] = $this->fixData($this->data[$c]);

			if ($this->isCopyImages) {
				$arrayUrlsClean = $this->getImageUrls($this->data[$c]);
				$inlineArrayNew = $this->imagesFromUrls($arrayUrlsClean);
				$inlineArray = array_merge($inlineArray, $inlineArrayNew);
				$this->data[$c] = $this->fixImageUrls($this->data[$c], $arrayUrlsClean, $this->root, $targetDir, $inlineArray);
				$usedFiles = array_merge($usedFiles, $arrayUrlsClean);

				foreach ($inlineArray as $file) {
					$usedFiles[] = $targetDir . $file['file'];
				}
			}

			$datapdo = array($this->id, $this->data[$c], $c + 1);
			$stmt = $this->pdo->prepare("INSERT INTO " . $this->tableNames["canvas"] . " (template_id, data,  page) values (?, ?, ?)");
			$qa[] = $stmt->execute($datapdo);
			$rc[] = $stmt->rowCount();
		}

		file_put_contents($this->root . $targetDir  . "../usedFiles.txt", implode("|", $usedFiles));


		if ($this->isCopyImages) {
			$this->createImages($inlineArray, $this->root, $targetDir);

			$this->copyImages($usedFiles, $this->root, $targetDir);
			// $usedFilesFinal = array_merge($usedFiles1, $usedFiles2);
			// $usedFilesAll = array_merge($usedFiles, $usedInlineFiles);
			$this->deleteUnusedFiles($usedFiles, $this->root, $targetDir);
			if ($this->optScreen != 0) {
				$this->copyImages($usedFiles, $this->root, $screenDir, $this->optScreen);
			}
		}

		$output["lastsql"] = $stmt;
		$output["qa"] = $qa;
		$output["rc"] = $rc;

		return $output;
	}
}



class ExportTemplatePNG extends ExportTemplate
{
	public function __construct($file, $data, $rawBgCoords)
	{
		$this->file = $file;
		$data = substr($data, strpos($data, ",") + 1);
		$data = str_replace(' ', '+', $data);
		$data = base64_decode($data);

		if ($rawBgCoords) {
			list($width_orig, $height_orig) = getimagesizefromstring($data);
			$new_width = $width_orig - $rawBgCoords['left'] - $rawBgCoords['right'];
			$new_height = $height_orig - $rawBgCoords['top'] - $rawBgCoords['bottom'];
			$im = imagecreatetruecolor($new_width, $new_height);
			imagealphablending($im, false);
			$backgroundColor = imagecolorallocate($im, 255, 255, 255);
			imagecolortransparent($im, $backgroundColor);
			imagefill($im, 0, 0, $backgroundColor);
			imagecopyresampled($im, imagecreatefromstring($data), 0, 0, $rawBgCoords['left'], $rawBgCoords['top'], $new_width, $new_height, $new_width, $new_height);
			imagesavealpha($im, true);
			ob_start();
			imagepng($im);
			$data = ob_get_clean();
		}

		$this->data = $data;
	}
}


class ExportTemplateSVG extends ExportTemplate
{
	public static function cleanSVG($data)
	{
		$search = array(
			'/\>[^\S ]+/s',  // strip whitespaces after tags, except space
			'/[^\S ]+\</s',  // strip whitespaces before tags, except space
			'/(\s)+/s'       // shorten multiple whitespace sequences
		);

		$replace = array(
			'>',
			'<',
			'\\1'
		);

		$data = str_replace("&quot;", "&#x22;", $data);
		$data = str_replace("&apos;", "&#x27;", $data);

		$data = preg_replace($search, $replace, $data);
		return $data;
	}

	public function __construct($file, $data)
	{
		$this->file = $file;
		$this->data = $data;
	}
}


class ExportTemplate
{
	protected $file = "";
	protected $data = "";

	public function __construct($file, $data)
	{
		$this->file = $file;
		$this->data = $data;
	}

	public function write()
	{
		$result = file_put_contents($this->file, $this->data);
		if ($result != false) {
			$output["qa"][] = 1;
		} else {
			$output["qa"][] = 0;
		}
		return $output;
	}
}
