<?php
include "headers.inc.php";
session_start(); if (!isset($_SESSION['loggedin'])) {echo '[]'; exit;}
include "functions.inc.php";
include "../assets/config/config.php";
include $canvasDirFromAdmin . "/assets/config/config.php";
$output = ["status" => 0];


$_POST = json_decode(file_get_contents("php://input"), true);

//TABLES SET NAMES
$products = $tableNames['products'];
$product_groups = $tableNames['product_groups'];

//VARS SET NAMES
$id = $_POST['id'];
$method = $_POST['method'];
$name = $_POST['name'];
$groups = $_GET['groups'];
$type = $_POST['type'];

//COLUMNS TO UPDATE
$varNameArray = [
  "name", "descr", "width", "height", "cut", "safe", "isround", "folds", "resolution", "visible", "minprice", "rawbg", "rawbgcoords",
  "maxpages", "link", "seotitle", "seoh1", "seodescr", "seokeywords", "seolink", "productGroupId", "templatelink", "pricelink", "fixedbg", "covermode", "roundcorners"
];
$booleans = ["visible", "fixedbg", "covermode"];


try {
  $pdo = new PDO('mysql:host=' . $pdohost . ';dbname=' . $pdobase . ';charset=utf8', $pdouser, $pdopass);
} catch (PDOException $e) {
  $output['syserror'] = $e->getMessage();
  $output['message'] = "PDO connection error";
}

if (isset($pdo)) {

  if (!$method && !$groups) {

    // $varSelectStr = implode(",", $varNameArray);
    foreach ($varNameArray as $varName) {
      if (isset($_POST[$varName])) {
        if (in_array($varName, $booleans)) {
          $varArray[] = (int) $_POST[$varName];
        } else {
          $varArray[] = $_POST[$varName];
        }
        $varNameArray2[] = camelToUnder($varName);
      }
    }
    $varUpdateStr = implode('=?,', $varNameArray2) . '=?';
  }

  $output['varArray'] = $varArray;
  $output['varNameArray2'] = $varNameArray2;


  //exit(print_r($varArray));

  if ($groups) {
    if (isset($id) && ($method == "delete")) {
      $stmt = $pdo->prepare("DELETE FROM $product_groups WHERE id=?");
      $qa[] = $stmt->execute([$id]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.GroupDeleted";
    } elseif (isset($name) && ($method == "delete")) {
      $stmt = $pdo->prepare("DELETE FROM $product_groups WHERE name=?");
      $qa[] = $stmt->execute([$name]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.GroupDeletedByName (For Postman Only)";
    } elseif (isset($id) && $method == "visible") {
      $stmt = $pdo->prepare("UPDATE $product_groups SET visible = visible XOR 1 WHERE id =?");
      $qa[] = $stmt->execute([$id]);
      $rc[] = $stmt->rowCount();
    } elseif ($id === 0) {
      $pdo->beginTransaction();
      $stmt = $pdo->prepare("INSERT INTO $product_groups SET name=?");
      $qa[] = $stmt->execute([$name]);
      $rc[] = $stmt->rowCount();
      $lid = $pdo->lastInsertId();
      $output["lid"] = $lid;
      $pdo->commit();
      $output["message"] = "i.GroupAdded";
    } else {
      $stmt = $pdo->prepare("UPDATE $product_groups SET name=? WHERE id=?");
      $qa[] = $stmt->execute([$name, $id]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.GroupUpdated";
    }
  } else {


    if (isset($id) && ($method == "visible")) {
      $stmt = $pdo->prepare("UPDATE $products SET visible = visible XOR 1 WHERE id=?");
      $qa[] = $stmt->execute([$id]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.ProductVisibilityChanged";
    } elseif (isset($id) && ($method == "delete")) {
      if ($type == "icon") {
        $stmt = $pdo->prepare("UPDATE $products SET icon='' WHERE id=?");
      } elseif ($type == "background") {
        $stmt = $pdo->prepare("UPDATE $products SET background='' WHERE id=?");
      } elseif ($type == "overlay") {
        $stmt = $pdo->prepare("UPDATE $products SET overlay='' WHERE id=?");
      } else {
        $stmt = $pdo->prepare("DELETE FROM $products WHERE id=?");
      }

      $qa[] = $stmt->execute([$id]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.ProductDeleted";
    } elseif (isset($name) && ($method == "delete")) {
      $stmt = $pdo->prepare("DELETE FROM $products WHERE name=?");
      $qa[] = $stmt->execute([$name]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.ProductDeleted";
    } else {
      if ($id === 0) {

        $pdo->beginTransaction();
        $stmt = $pdo->prepare("INSERT INTO $products SET " . $varUpdateStr);
        $qa[] = $stmt->execute($varArray);
        $rc[] = $stmt->rowCount();
        $lid = $pdo->lastInsertId();
        $pdo->commit();


        $output["lid"] = $lid;

        //$row=$stmt->fetch();      
        //if(is_array($row)){foreach ($row as $key=>$value){$output["data"][$key]=$value;}}

        if ($qa[count($qa) - 1] == true) {
          $output["message"] = "i.ProductCreated";
        } else {
          $output["message"] = "i.ProductCreateError:".implode('||', $varNameArray2);
        }
      } else {
        $stmt = $pdo->prepare("UPDATE $products SET $varUpdateStr WHERE id=?");
        $qa[] = $stmt->execute(array_merge($varArray, [$id]));
        $rc[] = $stmt->rowCount();
        if ($qa[count($qa) - 1] == true) {
          $output["message"] = "i.ProductUpdated";
        } else {
          $output["message"] = "i.ProductUpdateError:".implode('||', $varNameArray2);
        }
      }
    }
  } //if ($groups) {} else {}

  $output["message"] = isset($output["message"]) ? $output["message"] : "i.Done";
  $output["status"] = (in_array(false, $qa, true)) ? 0 : 1;
  $output["status"] = (count($qa) > 0) ? $output["status"] : 0;
  $output["lastsql"] = $stmt;
  $output["qa"] = $qa;
  $output["rc"] = $rc;
}
echo json_encode($output, $jsonEncMode);
