<?php
include "headers.inc.php";
session_start(); if (!isset($_SESSION['loggedin'])) {echo '[]'; exit;}
include "../assets/config/config.php";
include $canvasDirFromAdmin . "/assets/config/config.php";
$output = ["status" => 0];
//$prices = $tableNames['prices'];

$_POST = json_decode(file_get_contents("php://input"), true);


//TABLES SET NAMES
$price_rows = $tableNames['price_rows'];
$price_cells = $tableNames['price_cells'];
$price_options = $tableNames['price_options'];
$price_selects = $tableNames['price_selects'];

//VARS SET NAMES
$method = $_POST['method'];
$prices = $_POST['prices'];
$id = $_POST['id'];
$name = $_POST['name'];
$productId = $_POST['productId'];
$sortid = $_POST['sortid'];
$deletedIds = $_POST['deletedIds'];
$selects = $_GET['selects'];
$options = $_GET['options'];
$priceSelectId=$_POST['priceSelectId'];

try {
  $pdo = new PDO('mysql:host=' . $pdohost . ';dbname=' . $pdobase . ';charset=utf8', $pdouser, $pdopass);
} catch (PDOException $e) {
  $output['syserror'] = $e->getMessage();
  $output['message'] = "PDO connection error";
}

if (isset($pdo)) {

  if ($options) {
    if (isset($id) && ($method == "delete")) {
      $stmt = $pdo->prepare("DELETE FROM $price_options WHERE id=?");
      $qa[] = $stmt->execute([$id]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.PriceOptionDeleted";
    } elseif ($id === 0 && $priceSelectId) {
      $pdo->beginTransaction();
      $stmt = $pdo->prepare("INSERT INTO $price_options SET name=?, price_select_id=?, sortid=?");
      $qa[] = $stmt->execute([$name, $priceSelectId, $sortid]);
      $rc[] = $stmt->rowCount();
      $lid = $pdo->lastInsertId();
      $output["lid"] = $lid;
      $pdo->commit();
      $output["message"] = "i.PriceOptionAdded";
    } else {
      $stmt = $pdo->prepare("UPDATE $price_options SET name=?, sortid=? WHERE id=?");
      $qa[] = $stmt->execute([$name, $sortid, $id]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.PriceOptionUpdated";
    }
  } else  if ($selects) {
    if (isset($id) && ($method == "delete")) {
      $stmt = $pdo->prepare("DELETE FROM $price_selects WHERE id=?");
      $qa[] = $stmt->execute([$id]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.PriceSelectDeleted";
    } elseif ($id === 0 && $productId) {
      $pdo->beginTransaction();
      $stmt = $pdo->prepare("INSERT INTO $price_selects SET name=?, product_id=?, sortid=?");
      $qa[] = $stmt->execute([$name, $productId, $sortid]);
      $rc[] = $stmt->rowCount();
      $lid = $pdo->lastInsertId();
      $output["lid"] = $lid;
      $pdo->commit();
      $output["message"] = "i.PriceSelectAdded";
    } else {
      $stmt = $pdo->prepare("UPDATE $price_selects SET name=?, sortid=? WHERE id=?");
      $qa[] = $stmt->execute([$name, $sortid, $id]);
      $rc[] = $stmt->rowCount();
      $output["message"] = "i.PriceSelectUpdated";
    }
  } else {
    if (count($deletedIds) > 0) {
      foreach ($deletedIds as $did) {
        $stmt = $pdo->prepare("DELETE FROM $price_rows WHERE id=?");
        $qa[] = $stmt->execute([$did]);
        $rc[] = $stmt->rowCount();

        $stmt = $pdo->prepare("DELETE FROM $price_cells WHERE price_row_id=?");
        $qa[] = $stmt->execute([$did]);
        $rc[] = $stmt->rowCount();
      }
    }

    if (isset($productId) && count($prices) > 0) {
      foreach ($prices as $row) {

        if ($productId != $row['productId']) {
          $output["status"] = "0";
          $output["error"] = "product check error";
          break;
        }

        if ($row['id'] == 0) {// use == not ===

          $output["insert"] = 1;
          $pdo->beginTransaction();
          $stmt = $pdo->prepare("INSERT INTO $price_rows SET product_id=?, number=?, period=? ");
          $qa[] = $stmt->execute([$productId, $row['number'] ? $row['number'] : 0, $row['period']]);
          $rc[] = $stmt->rowCount();
          $lid = $pdo->lastInsertId();
          $pdo->commit();
          $c=0;
          foreach ($row['priceArray'] as $value) {
            $stmt = $pdo->prepare("INSERT INTO $price_cells SET price=?, columnid=?, price_row_id=? ");
            $qa[] = $stmt->execute([$value, $c, $lid]);
            $rc[] = $stmt->rowCount();
            $c++;
          }
        } else {

          $output["update"] = 1;
          $stmt = $pdo->prepare("UPDATE $price_rows SET number=?, period=? WHERE id=?");
          $qa[] = $stmt->execute([$row['number'], $row['period'], $row['id']]);
          $rc[] = $stmt->rowCount();
          if (count($row['priceArray']) > 0) {
            $c=0;
            foreach ($row['priceArray'] as  $value) {
              $stmt = $pdo->prepare("UPDATE $price_cells SET price=? WHERE columnid=? AND price_row_id=? ");
              $qa[] = $stmt->execute([$value, $c, $row['id']]);
              $rc[] = $stmt->rowCount();              
              if ($stmt->rowCount() == 0) {
                $stmt = $pdo->prepare("INSERT INTO $price_cells SET price=?, columnid=?, price_row_id=? ");
                $qa[] = $stmt->execute([$value, $c, $row['id']]);
                $rc[] = $stmt->rowCount();
              }
              $c++;
            }
          }
        }
      }
    } elseif (isset($productId) && ($method == "clear")) {
      $stmt = $pdo->prepare("DELETE  $price_cells FROM $price_cells LEFT JOIN  $price_rows  ON $price_cells.price_row_id = $price_rows.id WHERE $price_rows.productId = ?");
      $qa[] = $stmt->execute([$productId]);
      $rc[] = $stmt->rowCount();
      $stmt = $pdo->prepare("DELETE $price_rows FROM $price_rows  WHERE $price_rows.product_id = ?");
      $qa[] = $stmt->execute([$productId]);
      $rc[] = $stmt->rowCount();
    }
  }

  if (is_array($qa)) {
    if (count($qa) > 0) {
      if (in_array(false, $qa, true) == false)
        $output["status"] = 1;
    }
  }

  if (!$output["message"]) {
    $output["message"] = $output["status"] ? "i.PricesWereChanged" : "i.PricesUpdateError";
  }
  $output["lastsql"] = $stmt;
  $output["qa"] = $qa;
  $output["rc"] = $rc;
}
echo json_encode($output, $jsonEncMode);
