<?php
include "headers.inc.php";
session_start(); if (!isset($_SESSION['loggedin'])) {echo '[]'; exit;}
include "functions.inc.php";
include "../assets/config/config.php";
include $canvasDirFromAdmin . "/assets/config/config.php";
$output = [];

/** @var int This is a counter. */
$index = 0;

/**
 * Returns the name of this object.
 *
 * @return string
 */
//TABLES SET NAMES
$orderItems = $tableNames['order_items'];
$products = $tableNames['products'];

//VARS SET NAMES
$canvasAdminUrl2 = $canvasAdminUrl . "/../../adm2";
$id = $_GET["id"];
$isId = (isset($id) && $id != 0) ? true : false;

try {
  $pdo = new PDO('mysql:host=' . $pdohost . ';dbname=' . $pdobase . ';charset=utf8', $pdouser, $pdopass);
} catch (PDOException $e) {
  $output['syserror'] = $e->getMessage();
  $output['message'] = "PDO connection error";
}

if (isset($pdo)) {

  if ($isId) {

    $stmt = $pdo->prepare("SELECT $orderItems.*, $products.descr  as as_productname FROM $orderItems, $products WHERE order_id = ? AND $orderItems.product_id=$products.id ");
    $q = $stmt->execute([$id]);
    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);

    foreach ($result as $row) {

      if ($row["pdfready"]) {
        $output[$index]['files'][] = ["name" => "i.Pdf", "ext" => "zip", "page" => 0, "url" => $pdfServers[0] . "/getpdf.php?host=" . $_SERVER["HTTP_HOST"] . "&id=" . $row["id"]];
      } else if ($row["pdfready2"]) {
        $output[$index]['files'][] = ["name" => "i.Pdf", "ext" => "zip", "page" => 0, "url" => $pdfServers[1] . "/getpdf.php?host=" . $_SERVER["HTTP_HOST"] . "&id=" . $row["id"]];
      } else {
        $output[$index]['files'][] = ["name" => "i.Pdf", "ext" => "zip", "page" => 0, "url" => ""];
      }

      if (file_exists(($canvasDirFromAdmin . "data/orders/" . $row["filedir"] . "/page-print0.png"))) {
        $output[$index]['files'][] = ["name" => "i.Png", "ext" => "zip", "page" => 0, "url" => $canvasAdminUrl2 . "/php/items_zip.php?id=" . $row["id"]];
      } else {
        $output[$index]['files'][] = "0";
      }


      foreach ($row as $key => $value) {

        if ($key == "pages") {
          for ($c = 0; $c < $value; $c++) {
            if (!file_exists(($canvasDirFromAdmin . "data/orders/" . $row["filedir"] . "/page$c.png"))) {
              continue;
            }
            $output[$index]['files'][] = ["name" => "i.Preview", "ext" => "png", "page" => $c + 1, "url" => $canvasUrlFromAdmin . "data/orders/" . $row["filedir"] . "/page$c.png"];
          }
        }

        if ($key == "options") {
          $options = json_decode($value);
          foreach ($options as $optkey => $optval) {
            $output[$index][underToCamel($key)][] = ["key" => $optkey, "val" => $optval];
          }
        } else {
          $output[$index][underToCamel($key)] = $value;
        }
      }
      $index++;
    }
  }
}


echo json_encode($output, $jsonEncMode);
