<?php
include "headers.inc.php";
session_start(); if (!isset($_SESSION['loggedin'])) {echo '[]'; exit;}
include "../assets/config/config.php";
include $canvasDirFromAdmin."/assets/config/config.php";
include "./functions.inc.php";

$output = ["status" => 0];


//TABLES SET NAMES
$images = $tableNames['images'];
$image_groups = $tableNames['image_groups'];

//VARS SET NAMES
$variationArray=[2, 1.41, 1.8];//TODO: to config
$type=$_POST["type"];
$file = $_FILES["newfile"];
$skipOriginal=$_POST["skipOriginal"];
$generateVariations=$_POST["generateVariations"];
$groupId=$_POST["groupId"];
$tmp_name = $file["tmp_name"];
$error = $file["error"];
$name = basename($file["name"]);
$path_parts = pathinfo($name);        
$origid=mt_rand();


if($type=="assets") {
  $uploadDir=$canvasDirFromAdmin.$assetsDir;
  $generateVariations=false;
  $skipOriginal=false;
}	elseif($type=="backgrounds") {
  $uploadDir=$canvasDirFromAdmin.$backgroundsDir;
}	 else {
  $output["status"]=0;
  $output["error"]=1;
  $output["message"] = "i.NoTypeSelected!"; 
}

$newfilename = $type.mt_rand().".".$path_parts['extension'];
$newfiledir = $uploadDir."/images/";

if(!isset($groupId)) {
  $output["status"]=0;
  $output["error"]=1;
  $output["message"] = "i.NoGroupSelected!"; 
}

try {
  $pdo = new PDO('mysql:host='.$pdohost.';dbname='.$pdobase.';charset=utf8', $pdouser, $pdopass);
} catch (PDOException $e) {
  $output['syserror']=$e->getMessage();
  $output['message']="PDO connection error";
}

if (isset($pdo)) {
  if (isset($file) && isset($uploadDir) && isset($groupId)) { 

    list($w, $h) = getimagesize ($tmp_name);

    if($error > 0) {
      $output["status"]=0;
      $output["error"]=1;
      $output["message"] = "i.ErrorUploadingTheFile!";
    } 
    elseif(!($path_parts['extension']=="jpeg"|$path_parts['extension']=="jpg"|$path_parts['extension']=="png"|$path_parts['extension']=="svg")){
      $output["status"]=0;
      $output["error"]=1;
      $output["message"] = "i.BadFileExtension";
    } 
    elseif($path_parts['extension']!="svg" & ($w<100 | $h<100)){
      $output["status"]=0;
      $output["error"]=1;
      $output["message"] = "i.TooSmallImageSize";     
    }        
    else {        
        if(move_uploaded_file($tmp_name , $newfiledir.$newfilename)) {
          if(!$skipOriginal){				
            $uploadedFiles[]=array('file'=>$newfilename, 'origid'=>$origid);
          }
          
          if($generateVariations){			
            if($path_parts['extension']=="jpeg"|$path_parts['extension']=="jpg"|$path_parts['extension']=="png"){
              
              //list($w, $h) = getimagesize ($newfiledir.$newfilename);
              
              $variations[]=["width"=>min($w,$h),"height"=>min($w,$h)];

              foreach ($variationArray as $size)
              {
                if($h>=$w/$size){$variations[]=["width"=>$w,"height"=>$w/$size];}
                if($w>=$h/$size){$variations[]=["width"=>$h/$size, "height"=>$h];}
              }
              
              foreach($variations as $variation){
                $filename2 = mt_rand().".".$path_parts['extension'];
                $uploadfile2   = $uploadDir."/images/".$filename2;
                writeImageCroped($newfiledir.$newfilename, $variation, "$uploadfile2", $origid);	
                $uploadedFiles[]=array('file'=>$filename2, 'origid'=>$origid);
              }				
            }
          }
          
          if($skipOriginal){
            unlink($newfiledir.$newfilename);
          }          
          
          $c=0;
          foreach ($uploadedFiles as $uploadedFile) {			
        
            $filename = basename($uploadedFile['file']);
            $path_parts = pathinfo($filename);	        
            
            list($w, $h) = getimagesize ($newfiledir.$uploadedFile['file']);
            
            if($type=="assets"){
              $stmt = $pdo->prepare("INSERT INTO $images SET filename=?, img_group_id=?, type='assets', width=?, height=?, origid=?");
              $q = $stmt->execute([$filename, $groupId, $w, $h, $uploadedFile['origid']]); 
              $rc[] = $stmt->rowCount();                 
            }
            
            if($type=="backgrounds"){
              $stmt = $pdo->prepare("INSERT INTO $images SET filename=?, img_group_id=?, type='backgrounds', width=?, height=?, origid=?");
              $q = $stmt->execute([$filename, $groupId, $w, $h, $uploadedFile['origid']]);  
              $rc[] = $stmt->rowCount();     
            }
            
            $uploadfileSm = $uploadDir."/thumbs/".$filename;
            $uploadfileMd = $uploadDir."/screens/".$filename;
            
            if($path_parts['extension']=="jpeg"|$path_parts['extension']=="jpg"|$path_parts['extension']=="png"){
              writeImageResized($newfiledir.$uploadedFile['file'], $optScreenSize, $uploadfileMd, false);
              writeImageResized($newfiledir.$uploadedFile['file'], 100, $uploadfileSm, true);				
            }else{
              copy($newfiledir.$uploadedFile['file'], $uploadfileMd);
              copy($newfiledir.$uploadedFile['file'], $uploadfileSm);
            }
        
            $c++;
          }                    
          
          $output["status"]=1;
          $output["error"]=0;
          $output["message"] = "i.FileUploadedSuccessfully";
          $output["generated"]=$c;
          $output["uploadDir"]=$uploadDir;
          $output["lastsql"]=$stmt;
          $output["q"]=$q;
          $output["rc"]=$rc; 

        } else {                
          $output["status"]=0;
          $output["error"]=1;
          $output["message"] = "i.ErrorUploadingTheFile!";
          $output["rc"]=$rc; 
          $output["q"]=$q;
        }
    }
  }    

  $output["message"]=isset($output["message"])?$output["message"]:"i.Done";
  $output["status"] = ($q) ? $output["status"] : 0;
}
echo json_encode($output, $jsonEncMode);
?>